/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.entity;

import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.entity.RestRelationship;

public class RestEntityCache {
    private LruCache<Long, RestNode> lruNodeCache = new LruCache("RestNode", 10000);
    private LruCache<Long, RestRelationship> lruRelCache = new LruCache("RestRelationship", 10000);
    private final RestAPI restAPI;

    public RestEntityCache(RestAPI restAPI) {
        this.restAPI = restAPI;
    }

    public RestNode addToCache(RestNode node) {
        if (node == null) {
            return null;
        }
        long id = node.getId();
        if (id != -1L) {
            RestNode existing = (RestNode)this.lruNodeCache.get((Object)id);
            if (existing != null) {
                if (existing != node) {
                    existing.updateFrom(node, this.restAPI);
                }
                return existing;
            }
            this.lruNodeCache.put((Object)id, (Object)node);
        }
        return node;
    }

    public RestRelationship addToCache(RestRelationship rel) {
        if (rel == null) {
            return null;
        }
        long id = rel.getId();
        if (id != -1L) {
            RestRelationship existing = (RestRelationship)this.lruRelCache.get((Object)id);
            if (existing != null) {
                if (existing != rel) {
                    existing.updateFrom(rel, this.restAPI);
                }
                return existing;
            }
            this.lruRelCache.put((Object)id, (Object)rel);
        }
        return rel;
    }

    public RestNode getNode(long id) {
        return (RestNode)this.lruNodeCache.get((Object)id);
    }

    public RestRelationship getRelationship(long id) {
        return (RestRelationship)this.lruRelCache.get((Object)id);
    }

    public void removeNode(long id) {
        this.lruNodeCache.remove((Object)id);
    }

    public void removeRelationship(long id) {
        this.lruRelCache.remove((Object)id);
    }
}

