/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.entity;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.rest.graphdb.PropertiesMap;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestGraphDatabase;
import org.neo4j.rest.graphdb.UpdatableRestResult;
import org.neo4j.rest.graphdb.util.ArrayConverter;
import org.springframework.data.neo4j.core.UpdateableState;

public abstract class RestEntity
implements PropertyContainer,
UpdatableRestResult<RestEntity>,
UpdateableState {
    private Map<?, ?> structuralData;
    protected Map<String, Object> propertyData;
    private long lastTimeFetchedPropertyData;
    protected RestAPI restApi;
    private Long id;
    private final ArrayConverter arrayConverter = new ArrayConverter();
    private String uri;
    private boolean tracking;

    public RestEntity(URI uri, RestAPI restApi) {
        this(uri.toString(), restApi);
    }

    public RestEntity(String uri, RestAPI restApi) {
        this.uri = uri;
        this.id = RestEntity.getEntityId(uri);
        this.restApi = restApi;
    }

    public RestEntity(Map<?, ?> data, RestAPI restApi) {
        this.restApi = restApi;
        this.structuralData = data;
        this.uri = (String)data.get("self");
        this.id = RestEntity.getEntityId(this.uri);
        this.setProperties((Map)data.get("data"));
    }

    public RestEntity(long id, Map<String, Object> restData, RestAPI facade) {
        this.restApi = facade;
        this.structuralData = restData;
        this.uri = RestEntity.nodeUri(facade, id);
        this.id = id;
        this.setProperties((Map)this.structuralData.get("data"));
    }

    public RestEntity(RestEntity entity, RestAPI facade) {
        this.restApi = facade;
        this.structuralData = entity.structuralData;
        this.id = entity.id;
        this.uri = RestEntity.nodeUri(facade, this.id);
        this.setProperties((Map)this.structuralData.get("data"));
    }

    public static String nodeUri(RestAPI facade, long id) {
        return facade.getBaseUri() + "/node/" + id;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public void updateFrom(RestEntity updateEntity, RestAPI restApi) {
        this.uri = updateEntity.getUri();
        this.id = RestEntity.getEntityId(this.uri);
        this.structuralData = updateEntity.getStructuralData();
        if (updateEntity.lastTimeFetchedPropertyData > 0L && updateEntity.propertyData != null) {
            this.setProperties(updateEntity.propertyData);
        }
    }

    Map<?, ?> getStructuralData() {
        return this.structuralData;
    }

    Map<String, Object> getPropertyData() {
        if (this.hasToUpdateProperties()) {
            this.doUpdate();
        }
        return this.propertyData;
    }

    protected abstract void doUpdate();

    protected void setProperties(Map<String, Object> properties) {
        this.tracking = false;
        this.propertyData = properties;
        this.lastTimeFetchedPropertyData = System.currentTimeMillis();
    }

    protected boolean hasToUpdateProperties() {
        if (this.tracking) {
            return false;
        }
        if (this.propertyData == null) {
            return true;
        }
        return this.restApi.hasToUpdate(this.lastTimeFetchedPropertyData);
    }

    public Object getProperty(String key) {
        Object value = this.getPropertyValue(key);
        if (value == null) {
            throw new NotFoundException("'" + key + "' on " + this);
        }
        return value;
    }

    private Object getPropertyValue(String key) {
        Map<String, Object> properties = this.getPropertyData();
        Object value = properties.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            if (col.isEmpty()) {
                return new String[0];
            }
            Object result = this.arrayConverter.toArray(col);
            if (result == null) {
                throw new IllegalStateException("Could not determine type of property " + key);
            }
            properties.put(key, result);
            return result;
        }
        return PropertiesMap.assertSupportedPropertyValue(value);
    }

    public Object getProperty(String key, Object defaultValue) {
        Object value = this.getPropertyValue(key);
        return value != null ? value : defaultValue;
    }

    public Iterable<String> getPropertyKeys() {
        return new IterableWrapper(this.getPropertyData().keySet()){

            protected String underlyingObjectToObject(Object key) {
                return key.toString();
            }
        };
    }

    public Iterable<Object> getPropertyValues() {
        return this.getPropertyData().values();
    }

    public boolean hasProperty(String key) {
        return this.getPropertyData().containsKey(key);
    }

    public Object removeProperty(String key) {
        Object value = this.getProperty(key, null);
        if (!this.tracking) {
            this.restApi.removeProperty(this, key);
        }
        if (this.propertyData != null) {
            this.propertyData.remove(key);
        }
        return value;
    }

    public void setProperty(String key, Object value) {
        if (!this.tracking) {
            this.restApi.setPropertyOnEntity(this, key, value);
        }
        if (this.propertyData == null) {
            this.propertyData = new LinkedHashMap<String, Object>();
        }
        this.propertyData.put(key, value);
    }

    public void flush() {
        if (!this.tracking) {
            return;
        }
        if (this.propertyData != null && !this.propertyData.isEmpty()) {
            this.restApi.setPropertiesOnEntity(this, this.propertyData);
        }
        this.tracking = false;
    }

    public void track() {
        this.tracking = true;
    }

    public static long getEntityId(String uri) {
        if (uri.startsWith("{")) {
            return -1L;
        }
        return Long.parseLong(uri.substring(uri.lastIndexOf(47) + 1));
    }

    public long getId() {
        return this.id;
    }

    public void delete() {
        this.restApi.deleteEntity(this);
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClass().equals(o.getClass()) && this.getId() == ((RestEntity)o).getId();
    }

    public RestGraphDatabase getGraphDatabase() {
        return new RestGraphDatabase(this.restApi);
    }

    public String toString() {
        return this.getUri();
    }

    public RestAPI getRestApi() {
        return this.restApi;
    }

    public void setLastTimeFetchedPropertyData(long lastTimeFetchedPropertyData) {
        this.lastTimeFetchedPropertyData = lastTimeFetchedPropertyData;
    }

    public void refresh() {
        this.doUpdate();
    }

    public void addPropertiesBatch(Map<String, Object> properties) {
        this.setProperties(properties);
        this.restApi.setPropertiesOnEntity(this, this.propertyData);
    }

    public void addAllLabelsBatch(Collection<String> labels) {
    }
}

