/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.rest.graphdb.ExecutingRestRequest;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestAPIIndex;
import org.neo4j.rest.graphdb.RestRequest;
import org.neo4j.rest.graphdb.converter.RestIndexHitsConverter;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.entity.RestRelationship;
import org.neo4j.rest.graphdb.index.IndexInfo;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.index.RestIndexManager;
import org.neo4j.rest.graphdb.index.RetrievedIndexInfo;
import org.neo4j.rest.graphdb.index.SimpleIndexHits;
import org.neo4j.rest.graphdb.util.JsonHelper;

public class RestAPIIndexImpl
implements RestAPIIndex {
    private final RestRequest restRequest;
    private RestIndexManager restIndexManager;
    private Map<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
    private final RestAPI restAPI;

    public RestAPIIndexImpl(RestAPI restAPI) {
        this.restAPI = restAPI;
        this.restRequest = restAPI.getRestRequest();
        this.restIndexManager = new RestIndexManager(restAPI);
    }

    @Override
    public RestIndexManager index() {
        return this.restIndexManager;
    }

    public static String indexPath(Class entityType, String indexName) {
        return "index/" + RestAPIIndexImpl.indexTypeName(entityType) + "/" + ExecutingRestRequest.encode(indexName);
    }

    public static String queryPath(Class entityType, String indexName, String key, Object value) {
        return RestAPIIndexImpl.indexPath(entityType, indexName, key, null) + "?query=" + ExecutingRestRequest.encode(value);
    }

    public static String indexPath(Class entityType, String indexName, String key, Object value) {
        String typeName = RestAPIIndexImpl.indexTypeName(entityType);
        return "index/" + typeName + "/" + ExecutingRestRequest.encode(indexName) + (key != null ? "/" + ExecutingRestRequest.encode(key) : "") + (value != null ? "/" + ExecutingRestRequest.encode(value) : "");
    }

    public static String indexTypeName(Class entityType) {
        return entityType.getSimpleName().toLowerCase();
    }

    @Override
    public <S extends PropertyContainer> IndexHits<S> getIndex(Class<S> entityType, String indexName, String key, Object value) {
        String indexPath = RestAPIIndexImpl.indexPath(entityType, indexName, key, value);
        RequestResult response = this.restRequest.get(indexPath);
        if (response.statusIs((Response.StatusType)Response.Status.OK)) {
            return new RestIndexHitsConverter<S>(this.restAPI, entityType).convertFromRepresentation(response);
        }
        return new SimpleIndexHits<S>(Collections.emptyList(), 0, entityType, this.restAPI);
    }

    @Override
    public <S extends PropertyContainer> IndexHits<S> queryIndex(Class<S> entityType, String indexName, String key, Object value) {
        String indexPath = RestAPIIndexImpl.queryPath(entityType, indexName, key, value);
        RequestResult response = this.restRequest.get(indexPath);
        if (response.statusIs((Response.StatusType)Response.Status.OK)) {
            return new RestIndexHitsConverter<S>(this.restAPI, entityType).convertFromRepresentation(response);
        }
        return new SimpleIndexHits<S>(Collections.emptyList(), 0, entityType, this.restAPI);
    }

    private void deleteIndex(String indexPath) {
        this.getRestRequest().delete(indexPath);
    }

    @Override
    public void delete(RestIndex index) {
        this.deleteIndex(this.indexPath(index, null, null));
        this.resetIndex(index.getEntityType());
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity, String key, Object value) {
        String indexPath = this.indexPath(index, key, value);
        this.deleteIndex(this.indexPath(indexPath, entity));
        this.resetIndex(index.getEntityType());
    }

    protected <T extends PropertyContainer> String indexPath(String indexPath, T restEntity) {
        return indexPath + "/" + ((RestEntity)restEntity).getId();
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity, String key) {
        String indexPath = this.indexPath(index, key, null);
        this.deleteIndex(this.indexPath(indexPath, entity));
        this.resetIndex(index.getEntityType());
    }

    private String indexPath(RestIndex index, String key, Object value) {
        return RestAPIIndexImpl.indexPath(index.getEntityType(), index.getIndexName(), key, value);
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity) {
        this.deleteIndex(this.indexPath(this.indexPath(index, null, null), entity));
        this.resetIndex(index.getEntityType());
    }

    public String uniqueIndexPath(RestIndex index) {
        return this.indexPath(index, null, null) + "?uniqueness=get_or_create";
    }

    @Override
    public <T extends PropertyContainer> void addToIndex(T entity, RestIndex index, String key, Object value) {
        RestEntity restEntity = (RestEntity)entity;
        String uri = restEntity.getUri();
        if (value instanceof ValueContext) {
            value = ((ValueContext)value).getCorrectValue();
        }
        Map data = MapUtil.map((Object[])new Object[]{"key", key, "value", value, "uri", uri});
        RequestResult result = this.getRestRequest().post(this.indexPath(index, null, null), data);
        if (result.statusOtherThan((Response.StatusType)Response.Status.CREATED)) {
            throw new RuntimeException(String.format("Error adding element %d %s %s to index %s status %s\n%s", restEntity.getId(), key, value, index.getIndexName(), result.getStatus(), result.getText()));
        }
    }

    @Override
    public <T extends PropertyContainer> T putIfAbsent(T entity, RestIndex index, String key, Object value) {
        RestEntity restEntity = (RestEntity)entity;
        restEntity.flush();
        String uri = restEntity.getUri();
        if (value instanceof ValueContext) {
            value = ((ValueContext)value).getCorrectValue();
        }
        Map data = MapUtil.map((Object[])new Object[]{"key", key, "value", value, "uri", uri});
        RequestResult result = this.getRestRequest().post(this.uniqueIndexPath(index), data);
        if (result.statusIs((Response.StatusType)Response.Status.CREATED)) {
            if (index.getEntityType().equals(Node.class)) {
                return (T)this.createRestNode(result);
            }
            if (index.getEntityType().equals(Relationship.class)) {
                return (T)this.createRestRelationship(result, restEntity);
            }
        }
        if (result.statusIs((Response.StatusType)Response.Status.OK)) {
            return (T)((PropertyContainer)this.restAPI.getEntityExtractor().convertFromRepresentation(result));
        }
        throw new RuntimeException(String.format("Error adding element %d %s %s to index %s", restEntity.getId(), key, value, index.getIndexName()));
    }

    public RestNode createRestNode(RequestResult result) {
        if (result.statusIs((Response.StatusType)Response.Status.NOT_FOUND)) {
            throw new NotFoundException("Node not found");
        }
        RestNode node = null;
        if (result.statusIs((Response.StatusType)Response.Status.CREATED)) {
            RestNode restNode = node = result.isMap() ? new RestNode(result.toMap(), this.restAPI) : new RestNode(result.getLocation(), this.restAPI);
        }
        if (node == null && result.statusIs((Response.StatusType)Response.Status.OK)) {
            node = new RestNode(result.toMap(), this.restAPI);
        }
        return this.restAPI.addToCache(node);
    }

    public RestRelationship createRestRelationship(RequestResult requestResult, PropertyContainer element) {
        if (requestResult.statusOtherThan((Response.StatusType)Response.Status.CREATED)) {
            int status = requestResult.getStatus();
            throw new RuntimeException("Error creating relationship " + status + " " + requestResult.getText());
        }
        String location = requestResult.getLocation();
        if (requestResult.isMap()) {
            return new RestRelationship(requestResult.toMap(), this.restAPI);
        }
        return new RestRelationship(location, this.restAPI);
    }

    @Override
    public RestNode getOrCreateNode(RestIndex<Node> index, String key, Object value, Map<String, Object> properties, Collection<String> labels) {
        if (index == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + index + " key " + key + " value must not be null");
        }
        Map data = MapUtil.map((Object[])new Object[]{"key", key, "value", value, "properties", properties});
        RequestResult result = this.getRestRequest().post(this.uniqueIndexPath(index), data);
        if (result.statusIs((Response.StatusType)Response.Status.CREATED) || result.statusIs((Response.StatusType)Response.Status.OK)) {
            RestNode node = (RestNode)this.restAPI.getEntityExtractor().convertFromRepresentation(result);
            this.restAPI.addLabels(node, labels);
            node.setLabels(labels);
            return this.restAPI.addToCache(node);
        }
        throw new RuntimeException(String.format("Error retrieving or creating node for key %s and value %s with index %s", key, value, index.getIndexName()));
    }

    @Override
    public RestRelationship getOrCreateRelationship(RestIndex<Relationship> index, String key, Object value, RestNode start, RestNode end, String type, Map<String, Object> properties) {
        if (index == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + index + " key " + key + " value must not be null");
        }
        if (start == null || end == null || type == null) {
            throw new IllegalArgumentException("Neither start, end nore type must be null");
        }
        Map data = MapUtil.map((Object[])new Object[]{"key", key, "value", value, "properties", properties, "start", start.getUri(), "end", end.getUri(), "type", type});
        RequestResult result = this.getRestRequest().post(this.uniqueIndexPath(index), data);
        if (result.statusIs((Response.StatusType)Response.Status.CREATED) || result.statusIs((Response.StatusType)Response.Status.OK)) {
            return (RestRelationship)this.restAPI.getEntityExtractor().convertFromRepresentation(result);
        }
        throw new RuntimeException(String.format("Error retrieving or creating relationship for key %s and value %s with index %s", key, value, index.getIndexName()));
    }

    private String buildPathAutoIndexerStatus(Class<? extends PropertyContainer> clazz) {
        return this.buildPathAutoIndexerBase(clazz).append("/status").toString();
    }

    private StringBuilder buildPathAutoIndexerProperties(Class<? extends PropertyContainer> clazz) {
        return this.buildPathAutoIndexerBase(clazz).append("/properties");
    }

    private StringBuilder buildPathAutoIndexerBase(Class<? extends PropertyContainer> clazz) {
        return new StringBuilder().append("index/auto/").append(RestAPIIndexImpl.indexTypeName(clazz));
    }

    public RestRequest getRestRequest() {
        return this.restRequest;
    }

    @Override
    public <T extends PropertyContainer> RestIndex<T> getIndex(String indexName) {
        RestIndexManager index = this.index();
        if (index.existsForNodes(indexName)) {
            return index.forNodes(indexName);
        }
        if (index.existsForRelationships(indexName)) {
            return (RestIndex)index.forRelationships(indexName);
        }
        throw new IllegalArgumentException("Index " + indexName + " does not yet exist");
    }

    @Override
    public void createIndex(String type, String indexName, Map<String, String> config) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", indexName);
        data.put("config", config);
        this.restRequest.post("index/" + type, data);
        IndexInfo indexInfo = this.indexInfos.get(type);
        if (indexInfo != null) {
            indexInfo.setExpired();
        }
    }

    public void resetIndex(Class type) {
        if (Node.class.isAssignableFrom(type)) {
            this.indexInfo("node").setExpired();
        }
        if (Relationship.class.isAssignableFrom(type)) {
            this.indexInfo("relationship").setExpired();
        }
    }

    @Override
    public <T extends PropertyContainer> RestIndex<T> createIndex(Class<T> type, String indexName, Map<String, String> config) {
        this.resetIndex(type);
        if (Node.class.isAssignableFrom(type)) {
            return this.index().forNodes(indexName, (Map)config);
        }
        if (Relationship.class.isAssignableFrom(type)) {
            return (RestIndex)this.index().forRelationships(indexName, config);
        }
        throw new IllegalArgumentException("Required Node or Relationship types to create index, got " + type);
    }

    @Override
    public boolean isAutoIndexingEnabled(Class<? extends PropertyContainer> clazz) {
        RequestResult response = this.getRestRequest().get(this.buildPathAutoIndexerStatus(clazz));
        if (response.statusIs((Response.StatusType)Response.Status.OK)) {
            return Boolean.parseBoolean(response.getText());
        }
        throw new IllegalStateException("received " + response);
    }

    @Override
    public void setAutoIndexingEnabled(Class<? extends PropertyContainer> clazz, boolean enabled) {
        RequestResult response = this.getRestRequest().put(this.buildPathAutoIndexerStatus(clazz), enabled);
        if (response.statusOtherThan((Response.StatusType)Response.Status.NO_CONTENT)) {
            throw new IllegalStateException("received " + response);
        }
    }

    @Override
    public Set<String> getAutoIndexedProperties(Class forClass) {
        RequestResult response = this.getRestRequest().get(this.buildPathAutoIndexerProperties(forClass).toString());
        Collection autoIndexedProperties = (Collection)JsonHelper.readJson(response.getText());
        return new HashSet<String>(autoIndexedProperties);
    }

    @Override
    public void startAutoIndexingProperty(Class forClass, String s) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes("UTF-8"));
            RequestResult response = this.getRestRequest().post(this.buildPathAutoIndexerProperties(forClass).toString(), stream);
            if (response.statusOtherThan((Response.StatusType)Response.Status.NO_CONTENT)) {
                throw new IllegalStateException("received " + response);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void stopAutoIndexingProperty(Class forClass, String s) {
        RequestResult response = this.getRestRequest().delete(this.buildPathAutoIndexerProperties(forClass).append("/").append(s).toString());
        if (response.statusOtherThan((Response.StatusType)Response.Status.NO_CONTENT)) {
            throw new IllegalStateException("received " + response);
        }
    }

    @Override
    public IndexInfo indexInfo(String indexType) {
        IndexInfo indexInfo = this.indexInfos.get(indexType);
        if (indexInfo != null && !indexInfo.isExpired()) {
            return indexInfo;
        }
        RequestResult response = this.restRequest.get("index/" + ExecutingRestRequest.encode(indexType));
        indexInfo = new RetrievedIndexInfo(response);
        this.indexInfos.put(indexType, indexInfo);
        return indexInfo;
    }
}

