/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.neo4j.rest.graphdb.RestAPIImpl;
import org.neo4j.rest.graphdb.query.CypherResult;

public class CypherRestShell {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String uri = args.length > 0 ? args[0] : "http://localhost:7474/db/data";
        System.out.println("Connected to " + uri);
        try (RestAPIImpl restAPIFacade = args.length > 1 ? new RestAPIImpl(uri, args[1], args[2]) : new RestAPIImpl(uri);){
            String query;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Query: ");
            while ((query = reader.readLine()) != null && !query.isEmpty()) {
                long time = System.currentTimeMillis();
                CypherResult result = restAPIFacade.query(query, null);
                time = System.currentTimeMillis() - time;
                System.out.println(result.getColumns());
                List rows = (List)result.getData();
                for (List row : rows) {
                    System.out.println(row);
                }
                System.out.println(rows.size() + " row(s), roundtrip time " + time + " ms.");
                System.out.print("Query: ");
            }
        }
    }
}

