/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.Parameter;

abstract class StartClause {
    protected final SortedMap<Integer, PartInfo> partInfos = new TreeMap<Integer, PartInfo>();

    public StartClause(PartInfo partInfo) {
        this.partInfos.put(partInfo.getParameterIndex(), partInfo);
    }

    protected boolean hasMultipleParts() {
        return this.partInfos.size() > 1;
    }

    public abstract Map<Parameter, Object> resolveParameters(Map<Parameter, Object> var1, Neo4jTemplate var2);

    public PartInfo getPartInfo() {
        return (PartInfo)IteratorUtil.first(this.partInfos.values());
    }

    public boolean merge(PartInfo partInfo) {
        for (PartInfo info : this.partInfos.values()) {
            if (info.sameIdentifier(partInfo) && info.sameIndex(partInfo)) continue;
            return false;
        }
        this.partInfos.put(partInfo.getParameterIndex(), partInfo);
        return true;
    }

    public boolean sameIdentifier(PartInfo info) {
        for (PartInfo partInfo : this.partInfos.values()) {
            if (partInfo.sameIdentifier(info)) continue;
            return false;
        }
        return true;
    }

    public boolean sameIndex(PartInfo info) {
        for (PartInfo partInfo : this.partInfos.values()) {
            if (partInfo.sameIndex(info)) continue;
            return false;
        }
        return true;
    }

    protected Collection<PartInfo> getPartInfos() {
        return this.partInfos.values();
    }
}

