/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.HashSet;
import java.util.Set;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.WhereClause;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;
import org.springframework.util.StringUtils;

public class LabelBasedTypeRestrictingWhereClause
extends WhereClause {
    private String aliases;

    public LabelBasedTypeRestrictingWhereClause(PartInfo partInfo, Neo4jPersistentEntity entity, Neo4jTemplate template) {
        super(partInfo, template);
        Object[] aliasAsArray = this.collectAliases(entity.getEntityType()).toArray();
        this.aliases = StringUtils.arrayToDelimitedString((Object[])aliasAsArray, (String)":");
    }

    @Override
    public String toString() {
        return String.format("`%1$s`:%2$s", this.partInfo.getIdentifier(), this.aliases);
    }

    private Set<String> collectAliases(StoredEntityType entityType) {
        HashSet<String> aliases = new HashSet<String>();
        aliases.add("`" + entityType.getAlias().toString() + "`");
        for (StoredEntityType superType : entityType.getSuperTypes()) {
            aliases.addAll(this.collectAliases(superType));
        }
        return aliases;
    }
}

