/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.CypherGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.CypherQueryCreator;
import org.springframework.data.neo4j.repository.query.CypherQueryDefinition;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class DerivedCypherRepositoryQuery
extends CypherGraphRepositoryQuery {
    public static final Logger log = LoggerFactory.getLogger(DerivedCypherRepositoryQuery.class);
    private final CypherQueryDefinition query;

    public DerivedCypherRepositoryQuery(Neo4jMappingContext mappingContext, GraphQueryMethod queryMethod, Neo4jTemplate template) {
        super(queryMethod, template);
        Assert.notNull((Object)((Object)mappingContext));
        EntityMetadata info = queryMethod.getEntityInformation();
        PartTree tree = new PartTree(queryMethod.getName(), info.getJavaType());
        this.query = (CypherQueryDefinition)new CypherQueryCreator(tree, (MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty>)mappingContext, info.getJavaType(), (Parameters<?, ?>)queryMethod.getParameters(), template).createQuery();
        if (log.isDebugEnabled()) {
            log.debug("Derived query: " + this.query + "from method " + (Object)((Object)queryMethod));
        }
    }

    @Override
    public Map<Parameter, Object> resolveParameters(Map<Parameter, Object> parameters) {
        return super.resolveParameters(this.query.resolveParameters(parameters));
    }

    @Override
    protected String createQueryWithPagingAndSorting(ParameterAccessor accessor) {
        if (accessor.getPageable() != null) {
            return this.query.toQueryString(accessor.getPageable());
        }
        if (accessor.getSort() != null) {
            return this.query.toQueryString(accessor.getSort());
        }
        return this.query.toQueryString();
    }
}

