/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Iterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.CypherQueryBuilder;
import org.springframework.data.neo4j.repository.query.CypherQueryDefinition;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

class CypherQueryCreator
extends AbstractQueryCreator<CypherQueryDefinition, CypherQueryBuilder> {
    private final MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> context;
    private final Class<?> domainClass;
    private final Neo4jTemplate template;
    private boolean isCountProjection = false;
    private Parameters<?, ?> parameters;

    public CypherQueryCreator(PartTree tree, MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> context, Class<?> domainClass, Parameters<?, ?> parameters, Neo4jTemplate template) {
        super(tree);
        Assert.notNull(context);
        Assert.notNull(domainClass);
        Assert.notNull((Object)template);
        Assert.notNull(parameters);
        this.template = template;
        this.context = context;
        this.domainClass = domainClass;
        this.isCountProjection = tree.isCountProjection();
        this.parameters = parameters;
    }

    protected CypherQueryBuilder create(Part part, Iterator<Object> iterator) {
        CypherQueryBuilder builder = new CypherQueryBuilder(this.context, this.domainClass, this.template, this.parameters.getBindableParameters());
        if (this.isCountProjection) {
            builder = builder.asCountQuery();
        }
        builder.addRestriction(part);
        return builder;
    }

    protected CypherQueryBuilder and(Part part, CypherQueryBuilder builder, Iterator<Object> iterator) {
        return builder.addRestriction(part);
    }

    protected CypherQueryBuilder or(CypherQueryBuilder base, CypherQueryBuilder builder) {
        throw new UnsupportedOperationException("Or is not supported currently!");
    }

    protected CypherQueryDefinition complete(CypherQueryBuilder builder, Sort sort) {
        return builder.buildQuery(sort);
    }
}

