/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.neo4j.graphdb.ConstraintViolationException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class PropertyFieldAccessorFactory
implements FieldAccessorFactory {
    private final Neo4jTemplate template;

    public PropertyFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty f) {
        return f.isNeo4jPropertyType();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty field) {
        return new PropertyFieldAccessor(this.template, field);
    }

    public static class PropertyFieldAccessor
    implements FieldAccessor {
        protected final Neo4jTemplate template;
        protected final Neo4jPersistentProperty property;
        protected final String propertyName;
        protected final Class<?> fieldType;

        public PropertyFieldAccessor(Neo4jTemplate template, Neo4jPersistentProperty property) {
            this.template = template;
            this.property = property;
            this.propertyName = property.getNeo4jPropertyName();
            this.fieldType = property.getType();
        }

        @Override
        public boolean isWriteable(Object entity) {
            return true;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            Object propertyContainer = this.template.getPersistentState(entity);
            try {
                if (newVal == null) {
                    propertyContainer.removeProperty(this.propertyName);
                } else {
                    propertyContainer.setProperty(this.propertyName, newVal);
                }
            }
            catch (ConstraintViolationException cve) {
                throw new DataIntegrityViolationException("Unique constraint violated " + this.property.getOwner().getName() + "." + this.property.getName() + " new value " + newVal, (Throwable)cve);
            }
            return newVal;
        }

        @Override
        public final Object getValue(Object entity, MappingPolicy mappingPolicy) {
            return DoReturn.doReturn(this.doGetValue(entity));
        }

        protected Object doGetValue(Object entity) {
            Object element = this.template.getPersistentState(entity);
            if (element.hasProperty(this.propertyName)) {
                Object value = element.getProperty(this.propertyName);
                if (value == null || this.fieldType.isInstance(value)) {
                    return value;
                }
                return this.convertSimplePropertyValue(value);
            }
            return this.getDefaultValue(this.fieldType);
        }

        protected Object convertSimplePropertyValue(Object value) {
            if (this.template.getConversionService() != null) {
                return this.template.getConversionService().convert(value, this.fieldType);
            }
            return value;
        }

        private Object getDefaultValue(Class<?> type) {
            return this.property.getDefaultValue(this.template.getConversionService(), type);
        }

        @Override
        public Object getDefaultValue() {
            return this.getDefaultValue(this.fieldType);
        }
    }
}

