/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.Set;
import java.util.TreeSet;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.annotation.Labels;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class LabelFieldAccessorFactory
implements FieldAccessorFactory {
    private final Neo4jTemplate template;

    public LabelFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        return property.isAnnotationPresent(Labels.class);
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        return new LabelFieldAccessor(property, this.template);
    }

    public static class LabelFieldAccessor
    implements FieldAccessor {
        protected final Neo4jPersistentProperty property;
        private final Neo4jTemplate template;

        public LabelFieldAccessor(Neo4jPersistentProperty property, Neo4jTemplate template) {
            this.property = property;
            this.template = template;
        }

        @Override
        public boolean isWriteable(Object entity) {
            return true;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            if (entity == null) {
                return entity;
            }
            Object state = this.template.getPersistentState(entity);
            if (state instanceof Node) {
                Node node = (Node)state;
                Set<String> oldLabels = this.getLabels(node);
                for (String newLabel : (Iterable)newVal) {
                    if (oldLabels.remove(newLabel)) continue;
                    node.addLabel(DynamicLabel.label((String)newLabel));
                }
                for (String removedLabels : oldLabels) {
                    node.removeLabel(DynamicLabel.label((String)removedLabels));
                }
                return DoReturn.doReturn(newVal);
            }
            throw new MappingException("Error setting labels on " + entity);
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            Object state = this.template.getPersistentState(entity);
            if (state instanceof Node) {
                return DoReturn.doReturn(this.getLabels((Node)state));
            }
            throw new MappingException("Error retrieving labels from " + entity);
        }

        private Set<String> getLabels(Node state) {
            TreeSet<String> labels = new TreeSet<String>();
            for (Label label : state.getLabels()) {
                labels.add(label.name());
            }
            return labels;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

