/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.fieldaccess.DynamicProperties;
import org.springframework.data.neo4j.fieldaccess.DynamicPropertiesContainer;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.ManagedPrefixedDynamicProperties;
import org.springframework.data.neo4j.fieldaccess.PrefixedDynamicProperties;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class DynamicPropertiesFieldAccessorFactory
implements FieldAccessorFactory {
    private final Neo4jTemplate template;

    public DynamicPropertiesFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty f) {
        return DynamicProperties.class.isAssignableFrom(f.getType());
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty field) {
        return new DynamicPropertiesFieldAccessor(this.template, field.getNeo4jPropertyName(), field);
    }

    public static class DynamicPropertiesFieldAccessor
    implements FieldAccessor {
        private final String propertyNamePrefix;
        private final Neo4jPersistentProperty field;
        private final Neo4jTemplate template;

        public DynamicPropertiesFieldAccessor(Neo4jTemplate template, String propertyName, Neo4jPersistentProperty field) {
            this.template = template;
            this.propertyNamePrefix = propertyName;
            this.field = field;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            PrefixedDynamicProperties dynamicProperties;
            Object propertyContainer = this.template.getPersistentState(entity);
            if (newVal instanceof ManagedPrefixedDynamicProperties) {
                dynamicProperties = (ManagedPrefixedDynamicProperties)newVal;
            } else {
                dynamicProperties = new PrefixedDynamicProperties(this.propertyNamePrefix);
                if (newVal != null) {
                    DynamicProperties newPropertiesVal = (DynamicProperties)newVal;
                    for (String key : newPropertiesVal.getPropertyKeys()) {
                        dynamicProperties.setProperty(key, newPropertiesVal.getProperty(key));
                    }
                }
            }
            Set<String> dynamicProps = dynamicProperties.getPrefixedPropertyKeys();
            HashSet nodeProps = new HashSet();
            IteratorUtil.addToCollection((Iterable)propertyContainer.getPropertyKeys(), nodeProps);
            for (String prop : dynamicProps) {
                nodeProps.remove(prop);
            }
            for (String removedKey : nodeProps) {
                if (!dynamicProperties.isPrefixedKey(removedKey)) continue;
                propertyContainer.removeProperty(removedKey);
            }
            for (String key : dynamicProps) {
                propertyContainer.setProperty(key, dynamicProperties.getPrefixedProperty(key));
            }
            return newVal;
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            Object element = this.template.getPersistentState(entity);
            ManagedPrefixedDynamicProperties props = ManagedPrefixedDynamicProperties.create(this.propertyNamePrefix, this.field, entity, this.template, this, this.field.getMappingPolicy());
            for (String key : element.getPropertyKeys()) {
                props.setPropertyIfPrefixed(key, element.getProperty(key));
            }
            return DoReturn.doReturn(props);
        }

        @Override
        public boolean isWriteable(Object entity) {
            return true;
        }

        @Override
        public Object getDefaultValue() {
            return new DynamicPropertiesContainer();
        }
    }
}

