/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro.shaded.org.apache.avro.util.internal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.util.TokenBuffer;
import parquet.avro.shaded.org.apache.avro.AvroRuntimeException;
import parquet.avro.shaded.org.apache.avro.JsonProperties;
import parquet.avro.shaded.org.apache.avro.Schema;

public class JacksonUtils {
    static final String BYTES_CHARSET = "ISO-8859-1";

    private JacksonUtils() {
    }

    public static JsonNode toJsonNode(Object datum) {
        if (datum == null) {
            return null;
        }
        try {
            TokenBuffer generator = new TokenBuffer((ObjectCodec)new ObjectMapper());
            JacksonUtils.toJson(datum, (JsonGenerator)generator);
            return new ObjectMapper().readTree(generator.asParser());
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    static void toJson(Object datum, JsonGenerator generator) throws IOException {
        if (datum == JsonProperties.NULL_VALUE) {
            generator.writeNull();
        } else if (datum instanceof Map) {
            generator.writeStartObject();
            for (Map.Entry entry : ((Map)datum).entrySet()) {
                generator.writeFieldName(entry.getKey().toString());
                JacksonUtils.toJson(entry.getValue(), generator);
            }
            generator.writeEndObject();
        } else if (datum instanceof Collection) {
            generator.writeStartArray();
            for (Object element : (Collection)datum) {
                JacksonUtils.toJson(element, generator);
            }
            generator.writeEndArray();
        } else if (datum instanceof byte[]) {
            generator.writeString(new String((byte[])datum, BYTES_CHARSET));
        } else if (datum instanceof CharSequence || datum instanceof Enum) {
            generator.writeString(datum.toString());
        } else if (datum instanceof Double) {
            generator.writeNumber(((Double)datum).doubleValue());
        } else if (datum instanceof Float) {
            generator.writeNumber(((Float)datum).floatValue());
        } else if (datum instanceof Long) {
            generator.writeNumber(((Long)datum).longValue());
        } else if (datum instanceof Integer) {
            generator.writeNumber(((Integer)datum).intValue());
        } else if (datum instanceof Boolean) {
            generator.writeBoolean(((Boolean)datum).booleanValue());
        }
    }

    public static Object toObject(JsonNode jsonNode) {
        return JacksonUtils.toObject(jsonNode, null);
    }

    public static Object toObject(JsonNode jsonNode, Schema schema) {
        if (schema != null && schema.getType().equals((Object)Schema.Type.UNION)) {
            return JacksonUtils.toObject(jsonNode, schema.getTypes().get(0));
        }
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode.isNull()) {
            return JsonProperties.NULL_VALUE;
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        if (jsonNode.isInt()) {
            if (schema == null || schema.getType().equals((Object)Schema.Type.INT)) {
                return jsonNode.asInt();
            }
            if (schema.getType().equals((Object)Schema.Type.LONG)) {
                return jsonNode.asLong();
            }
        } else {
            if (jsonNode.isLong()) {
                return jsonNode.asLong();
            }
            if (jsonNode.isDouble()) {
                if (schema == null || schema.getType().equals((Object)Schema.Type.DOUBLE)) {
                    return jsonNode.asDouble();
                }
                if (schema.getType().equals((Object)Schema.Type.FLOAT)) {
                    return Float.valueOf((float)jsonNode.asDouble());
                }
            } else if (jsonNode.isTextual()) {
                if (schema == null || schema.getType().equals((Object)Schema.Type.STRING) || schema.getType().equals((Object)Schema.Type.ENUM)) {
                    return jsonNode.asText();
                }
                if (schema.getType().equals((Object)Schema.Type.BYTES)) {
                    try {
                        return jsonNode.getTextValue().getBytes(BYTES_CHARSET);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new AvroRuntimeException(e);
                    }
                }
            } else {
                if (jsonNode.isArray()) {
                    ArrayList<Object> l = new ArrayList<Object>();
                    for (JsonNode node : jsonNode) {
                        l.add(JacksonUtils.toObject(node, schema == null ? null : schema.getElementType()));
                    }
                    return l;
                }
                if (jsonNode.isObject()) {
                    LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                    Iterator it = jsonNode.getFieldNames();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        Schema s = null;
                        if (schema == null) {
                            s = null;
                        } else if (schema.getType().equals((Object)Schema.Type.MAP)) {
                            s = schema.getValueType();
                        } else if (schema.getType().equals((Object)Schema.Type.RECORD)) {
                            s = schema.getField(key).schema();
                        }
                        Object value = JacksonUtils.toObject(jsonNode.get(key), s);
                        m.put(key, value);
                    }
                    return m;
                }
            }
        }
        return null;
    }
}

