/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.BLOB;

public class OracleBlobOutputStream
extends OutputStream {
    long lob_offset;
    BLOB blob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;

    public OracleBlobOutputStream(BLOB bLOB) throws SQLException {
        this(bLOB, bLOB.getConnection().db_access.getDefaultStreamChunkSize());
    }

    public OracleBlobOutputStream(BLOB bLOB, int n) throws SQLException {
        if (bLOB == null || n <= 0) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.blob = bLOB;
        this.lob_offset = 1L;
        this.buf = new byte[n];
        this.count = 0;
        this.bufSize = n;
        this.isClosed = false;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DBError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.count > 0) {
                if (this.count < this.buf.length) {
                    byte[] byArray = new byte[this.count];
                    System.arraycopy(this.buf, 0, byArray, 0, this.count);
                    this.lob_offset += (long)this.blob.putBytes((int)this.lob_offset, byArray);
                } else {
                    this.lob_offset += (long)this.blob.putBytes((int)this.lob_offset, this.buf);
                }
                this.count = 0;
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        int n3 = n;
        int n4 = n3 + Math.min(n2, byArray.length - n);
        while (n3 < n4) {
            int n5 = Math.min(this.bufSize - this.count, n4 - n3);
            System.arraycopy(byArray, n3, this.buf, this.count, n5);
            n3 += n5;
            this.count += n5;
            if (this.count < this.bufSize) continue;
            this.flushBuffer();
        }
    }
}

