/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.Closeable;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexAccessorReader;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.register.Register;

class LuceneUniqueIndexAccessorReader
extends LuceneIndexAccessorReader {
    LuceneUniqueIndexAccessorReader(IndexSearcher searcher, LuceneDocumentStructure documentLogic, Closeable onClose, CancellationRequest cancellation) {
        super(searcher, documentLogic, onClose, cancellation, -1);
    }

    @Override
    public long sampleIndex(Register.DoubleLong.Out result) throws IndexNotFoundKernelException {
        UniqueIndexSampler sampler = new UniqueIndexSampler();
        sampler.increment(this.luceneIndexReader().numDocs());
        this.checkCancellation();
        return sampler.result(result);
    }
}

