/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.MultipleBackupDeletionPolicy;
import org.neo4j.kernel.api.impl.index.IndexWriterFactory;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.ReservingLuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.TrackingLuceneIndexWriter;

public final class IndexWriterFactories {
    private IndexWriterFactories() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static IndexWriterFactory<ReservingLuceneIndexWriter> reserving() {
        return new IndexWriterFactory<ReservingLuceneIndexWriter>(){

            @Override
            public ReservingLuceneIndexWriter create(Directory directory) throws IOException {
                return new ReservingLuceneIndexWriter(directory, IndexWriterFactories.standardConfig());
            }
        };
    }

    public static IndexWriterFactory<LuceneIndexWriter> tracking() {
        return new IndexWriterFactory<LuceneIndexWriter>(){

            @Override
            public LuceneIndexWriter create(Directory directory) throws IOException {
                return new TrackingLuceneIndexWriter(directory, IndexWriterFactories.standardConfig());
            }
        };
    }

    public static IndexWriterFactory<LuceneIndexWriter> batchInsert(final IndexWriterConfig config) {
        return new IndexWriterFactory<LuceneIndexWriter>(){

            @Override
            public LuceneIndexWriter create(Directory directory) throws IOException {
                return new TrackingLuceneIndexWriter(directory, config);
            }
        };
    }

    private static IndexWriterConfig standardConfig() {
        IndexWriterConfig writerConfig = new IndexWriterConfig(Version.LUCENE_36, LuceneDataSource.KEYWORD_ANALYZER);
        writerConfig.setMaxBufferedDocs(100000);
        writerConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new MultipleBackupDeletionPolicy());
        writerConfig.setTermIndexInterval(14);
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setUseCompoundFile(true);
        mergePolicy.setNoCFSRatio(1.0);
        mergePolicy.setMinMergeMB(0.1);
        mergePolicy.setMergeFactor(2);
        writerConfig.setMergePolicy((MergePolicy)mergePolicy);
        return writerConfig;
    }
}

