/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.index.IndexCommandFactory;
import org.neo4j.graphdb.index.LegacyIndexProviderTransaction;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.impl.lucene.LuceneTransactionState;
import org.neo4j.kernel.api.LegacyIndex;
import org.neo4j.kernel.impl.index.IndexEntityType;

public class LuceneLegacyIndexTransaction
implements LegacyIndexProviderTransaction {
    private final LuceneDataSource dataSource;
    private final Map<String, LuceneIndex> nodeIndexes = new HashMap<String, LuceneIndex>();
    private final Map<String, LuceneIndex> relationshipIndexes = new HashMap<String, LuceneIndex>();
    private final LuceneTransactionState luceneTransaction;
    private final IndexCommandFactory commandFactory;

    public LuceneLegacyIndexTransaction(LuceneDataSource dataSource, IndexCommandFactory commandFactory) {
        this.dataSource = dataSource;
        this.commandFactory = commandFactory;
        this.luceneTransaction = new LuceneTransactionState();
    }

    public LegacyIndex nodeIndex(String indexName, Map<String, String> configuration) {
        LuceneIndex index = this.nodeIndexes.get(indexName);
        if (index == null) {
            IndexIdentifier identifier = new IndexIdentifier(IndexEntityType.Node, indexName);
            index = new LuceneIndex.NodeIndex(this.dataSource, identifier, this.luceneTransaction, IndexType.getIndexType(configuration), this.commandFactory);
            this.nodeIndexes.put(indexName, index);
        }
        return index;
    }

    public LegacyIndex relationshipIndex(String indexName, Map<String, String> configuration) {
        LuceneIndex index = this.relationshipIndexes.get(indexName);
        if (index == null) {
            IndexIdentifier identifier = new IndexIdentifier(IndexEntityType.Relationship, indexName);
            index = new LuceneIndex.RelationshipIndex(this.dataSource, identifier, this.luceneTransaction, IndexType.getIndexType(configuration), this.commandFactory);
            this.relationshipIndexes.put(indexName, index);
        }
        return index;
    }

    public void close() {
        this.luceneTransaction.close();
    }
}

