/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.neo4j.helpers.Clock;
import org.neo4j.logging.Log;

public class CappedLogger {
    private final Log delegate;
    private volatile Filter filter;

    public CappedLogger(Log delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("The delegate StringLogger cannot be null");
        }
        this.filter = new Filter();
        this.delegate = delegate;
    }

    public void debug(String msg) {
        if (this.filter.accept(msg, null)) {
            this.delegate.debug(msg);
        }
    }

    public void debug(String msg, Throwable cause) {
        if (this.filter.accept(msg, cause)) {
            this.delegate.debug(msg, cause);
        }
    }

    public void info(String msg) {
        if (this.filter.accept(msg, null)) {
            this.delegate.info(msg);
        }
    }

    public void info(String msg, Throwable cause) {
        if (this.filter.accept(msg, cause)) {
            this.delegate.info(msg, cause);
        }
    }

    public void warn(String msg) {
        if (this.filter.accept(msg, null)) {
            this.delegate.warn(msg);
        }
    }

    public void warn(String msg, Throwable cause) {
        if (this.filter.accept(msg, cause)) {
            this.delegate.warn(msg, cause);
        }
    }

    public void error(String msg) {
        if (this.filter.accept(msg, null)) {
            this.delegate.error(msg);
        }
    }

    public void error(String msg, Throwable cause) {
        if (this.filter.accept(msg, cause)) {
            this.delegate.error(msg, cause);
        }
    }

    public void reset() {
        this.filter = this.filter.reset();
    }

    public CappedLogger setCountLimit(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("The count limit must be positive");
        }
        this.filter = this.filter.setCountLimit(limit);
        return this;
    }

    public CappedLogger unsetCountLimit() {
        this.filter = this.filter.unsetCountLimit();
        return this;
    }

    public CappedLogger setTimeLimit(long time, TimeUnit unit, Clock clock) {
        if (time < 1L) {
            throw new IllegalArgumentException("The time limit must be positive");
        }
        if (unit == null) {
            throw new IllegalArgumentException("The time unit cannot be null");
        }
        if (clock == null) {
            throw new IllegalArgumentException("The clock used for time limiting cannot be null");
        }
        this.filter = this.filter.setTimeLimit(time, unit, clock);
        return this;
    }

    public CappedLogger unsetTimeLimit() {
        this.filter = this.filter.unsetTimeLimit();
        return this;
    }

    public CappedLogger setDuplicateFilterEnabled(boolean enabled) {
        this.filter = this.filter.setDuplicateFilterEnabled(enabled);
        return this;
    }

    private static class Filter {
        private static final AtomicIntegerFieldUpdater<Filter> CURRENT_COUNT = AtomicIntegerFieldUpdater.newUpdater(Filter.class, "currentCount");
        private static final AtomicLongFieldUpdater<Filter> LAST_CHECK = AtomicLongFieldUpdater.newUpdater(Filter.class, "lastCheck");
        private boolean hasCountLimit;
        private int countLimit;
        private long timeLimitMillis;
        private Clock clock;
        private boolean filterDuplicates;
        private volatile int currentCount;
        private volatile long lastCheck;
        private String lastMessage;
        private Throwable lastException;

        private Filter() {
            this(false, 0, 0, 0L, 0L, null, false);
        }

        private Filter(boolean hasCountLimit, int countLimit, int currentCount, long timeLimitMillis, long lastCheck, Clock clock, boolean filterDuplicates) {
            this.hasCountLimit = hasCountLimit;
            this.countLimit = countLimit;
            this.currentCount = currentCount;
            this.timeLimitMillis = timeLimitMillis;
            this.lastCheck = lastCheck;
            this.clock = clock;
            this.filterDuplicates = filterDuplicates;
        }

        public Filter setCountLimit(int limit) {
            return new Filter(true, limit, this.currentCount, this.timeLimitMillis, this.lastCheck, this.clock, this.filterDuplicates);
        }

        public boolean accept(String msg, Throwable cause) {
            return !(this.hasCountLimit && this.getAndIncrementCurrentCount() >= this.countLimit || this.clock != null && this.checkExpiredAndSetLastCheckTime() || this.filterDuplicates && !this.checkDuplicate(msg, cause));
        }

        public int getAndIncrementCurrentCount() {
            return CURRENT_COUNT.getAndIncrement(this);
        }

        private boolean checkExpiredAndSetLastCheckTime() {
            long check = this.lastCheck;
            long now = this.clock.currentTimeMillis();
            if (check > now - this.timeLimitMillis) {
                return true;
            }
            while (!LAST_CHECK.compareAndSet(this, check, now) && (check = this.lastCheck) <= now) {
            }
            return false;
        }

        private synchronized boolean checkDuplicate(String msg, Throwable cause) {
            String last = this.lastMessage;
            Throwable exc = this.lastException;
            if (this.stringEqual(last, msg) && this.sameClass(cause, exc) && this.sameMsg(cause, exc)) {
                return false;
            }
            this.lastMessage = msg;
            this.lastException = cause;
            return true;
        }

        private boolean sameMsg(Throwable cause, Throwable exc) {
            return cause == null && exc == null || cause != null && exc != null && this.stringEqual(exc.getMessage(), cause.getMessage());
        }

        private boolean stringEqual(String a, String b) {
            return a == null ? b == null : a.equals(b);
        }

        private boolean sameClass(Throwable cause, Throwable exc) {
            return cause == null && exc == null || cause != null && exc != null && exc.getClass().equals(cause.getClass());
        }

        public Filter reset() {
            return new Filter(this.hasCountLimit, this.countLimit, 0, this.timeLimitMillis, 0L, this.clock, this.filterDuplicates);
        }

        public Filter unsetCountLimit() {
            return new Filter(false, 0, this.currentCount, this.timeLimitMillis, this.lastCheck, this.clock, this.filterDuplicates);
        }

        public Filter setTimeLimit(long time, TimeUnit unit, Clock clock) {
            return new Filter(this.hasCountLimit, this.countLimit, this.currentCount, unit.toMillis(time), this.lastCheck, clock, this.filterDuplicates);
        }

        public Filter unsetTimeLimit() {
            return new Filter(this.hasCountLimit, this.countLimit, this.currentCount, 0L, this.lastCheck, null, this.filterDuplicates);
        }

        public Filter setDuplicateFilterEnabled(boolean enabled) {
            return new Filter(this.hasCountLimit, this.countLimit, this.currentCount, this.timeLimitMillis, this.lastCheck, this.clock, enabled);
        }
    }
}

