/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts.keys;

import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.util.IdPrettyPrinter;

public final class RelationshipKey
implements CountsKey {
    private final int startLabelId;
    private final int typeId;
    private final int endLabelId;

    RelationshipKey(int startLabelId, int typeId, int endLabelId) {
        this.startLabelId = startLabelId;
        this.typeId = typeId;
        this.endLabelId = endLabelId;
    }

    public String toString() {
        return String.format("RelationshipKey[(%s)-%s->(%s)]", IdPrettyPrinter.label(this.startLabelId), IdPrettyPrinter.relationshipType(this.typeId), IdPrettyPrinter.label(this.endLabelId));
    }

    @Override
    public void accept(CountsVisitor visitor, long ignored, long count) {
        visitor.visitRelationshipCount(this.startLabelId, this.typeId, this.endLabelId, count);
    }

    @Override
    public CountsKeyType recordType() {
        return CountsKeyType.ENTITY_RELATIONSHIP;
    }

    public int hashCode() {
        int result = this.startLabelId;
        result = 31 * result + this.typeId;
        result = 31 * result + this.endLabelId;
        result = 31 * result + this.recordType().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RelationshipKey) {
            RelationshipKey that = (RelationshipKey)o;
            return this.endLabelId == that.endLabelId && this.startLabelId == that.startLabelId && this.typeId == that.typeId;
        }
        return false;
    }

    @Override
    public int compareTo(CountsKey other) {
        if (other instanceof RelationshipKey) {
            RelationshipKey that = (RelationshipKey)other;
            if (this.typeId != that.typeId) {
                return this.typeId - that.typeId;
            }
            if (this.startLabelId != that.startLabelId) {
                return this.startLabelId - that.startLabelId;
            }
            return this.endLabelId - that.endLabelId;
        }
        return this.recordType().ordinal() - other.recordType().ordinal();
    }
}

