/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Map;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.AbstractAutoIndexerImpl;
import org.neo4j.kernel.impl.coreapi.IndexProvider;
import org.neo4j.kernel.impl.coreapi.RelationshipAutoIndexerImpl;

public class IndexManagerImpl
implements IndexManager {
    private final ThreadToStatementContextBridge transactionBridge;
    private final IndexProvider provider;
    private final AutoIndexer<Node> nodeAutoIndexer;
    private final RelationshipAutoIndexer relAutoIndexer;

    public IndexManagerImpl(ThreadToStatementContextBridge bridge, IndexProvider provider, AutoIndexer<Node> nodeAutoIndexer, RelationshipAutoIndexer relAutoIndexer) {
        this.transactionBridge = bridge;
        this.provider = provider;
        this.nodeAutoIndexer = nodeAutoIndexer;
        this.relAutoIndexer = relAutoIndexer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existsForNodes(String indexName) {
        try (Statement statement = this.transactionBridge.get();){
            statement.readOperations().nodeLegacyIndexGetConfiguration(indexName);
            boolean bl = true;
            return bl;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            return false;
        }
    }

    @Override
    public Index<Node> forNodes(String indexName) {
        return this.forNodes(indexName, null);
    }

    @Override
    public Index<Node> forNodes(String indexName, Map<String, String> customConfiguration) {
        Index<Node> toReturn = this.provider.getOrCreateNodeIndex(indexName, customConfiguration);
        if ("node_auto_index".equals(indexName)) {
            toReturn = new AbstractAutoIndexerImpl.ReadOnlyIndexToIndexAdapter<Node>(toReturn);
        }
        return toReturn;
    }

    @Override
    public String[] nodeIndexNames() {
        try (Statement statement = this.transactionBridge.get();){
            String[] stringArray = statement.readOperations().nodeLegacyIndexesGetAll();
            return stringArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existsForRelationships(String indexName) {
        try (Statement statement = this.transactionBridge.get();){
            statement.readOperations().relationshipLegacyIndexGetConfiguration(indexName);
            boolean bl = true;
            return bl;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            return false;
        }
    }

    @Override
    public RelationshipIndex forRelationships(String indexName) {
        return this.forRelationships(indexName, null);
    }

    @Override
    public RelationshipIndex forRelationships(String indexName, Map<String, String> customConfiguration) {
        RelationshipIndex toReturn = this.provider.getOrCreateRelationshipIndex(indexName, customConfiguration);
        if ("relationship_auto_index".equals(indexName)) {
            toReturn = new RelationshipAutoIndexerImpl.RelationshipReadOnlyIndexToIndexAdapter(toReturn);
        }
        return toReturn;
    }

    @Override
    public String[] relationshipIndexNames() {
        try (Statement statement = this.transactionBridge.get();){
            String[] stringArray = statement.readOperations().relationshipLegacyIndexesGetAll();
            return stringArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> getConfiguration(Index<? extends PropertyContainer> index) {
        try (Statement statement = this.transactionBridge.get();){
            if (index.getEntityType().equals(Node.class)) {
                Map<String, String> map = statement.readOperations().nodeLegacyIndexGetConfiguration(index.getName());
                return map;
            }
            if (index.getEntityType().equals(Relationship.class)) {
                Map<String, String> map = statement.readOperations().relationshipLegacyIndexGetConfiguration(index.getName());
                return map;
            }
            throw new IllegalArgumentException("Unknown entity type " + index.getEntityType().getSimpleName());
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException("No node index '" + index.getName() + "' found");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String setConfiguration(Index<? extends PropertyContainer> index, String key, String value) {
        try (Statement statement = this.transactionBridge.get();){
            if (index.getEntityType().equals(Node.class)) {
                String string = statement.dataWriteOperations().nodeLegacyIndexSetConfiguration(index.getName(), key, value);
                return string;
            }
            if (index.getEntityType().equals(Relationship.class)) {
                String string = statement.dataWriteOperations().relationshipLegacyIndexSetConfiguration(index.getName(), key, value);
                return string;
            }
            throw new IllegalArgumentException("Unknown entity type " + index.getEntityType().getSimpleName());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String removeConfiguration(Index<? extends PropertyContainer> index, String key) {
        try (Statement statement = this.transactionBridge.get();){
            if (index.getEntityType().equals(Node.class)) {
                String string = statement.dataWriteOperations().nodeLegacyIndexRemoveConfiguration(index.getName(), key);
                return string;
            }
            if (index.getEntityType().equals(Relationship.class)) {
                String string = statement.dataWriteOperations().relationshipLegacyIndexRemoveConfiguration(index.getName(), key);
                return string;
            }
            throw new IllegalArgumentException("Unknown entity type " + index.getEntityType().getSimpleName());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException(e);
        }
    }

    @Override
    public AutoIndexer<Node> getNodeAutoIndexer() {
        return this.nodeAutoIndexer;
    }

    @Override
    public RelationshipAutoIndexer getRelationshipAutoIndexer() {
        return this.relAutoIndexer;
    }
}

