/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.util.DurationLogger;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

class OnlineIndexSamplingJob
implements IndexSamplingJob {
    private final IndexDescriptor indexDescriptor;
    private final IndexProxy indexProxy;
    private final IndexStoreView storeView;
    private final Log log;
    private final String indexUserDescription;

    public OnlineIndexSamplingJob(IndexProxy indexProxy, IndexStoreView storeView, String indexUserDescription, LogProvider logProvider) {
        this.indexDescriptor = indexProxy.getDescriptor();
        this.indexProxy = indexProxy;
        this.storeView = storeView;
        this.log = logProvider.getLog(this.getClass());
        this.indexUserDescription = indexUserDescription;
    }

    @Override
    public IndexDescriptor descriptor() {
        return this.indexDescriptor;
    }

    @Override
    public void run() {
        try (DurationLogger durationLogger = new DurationLogger(this.log, "Sampling index " + this.indexUserDescription);){
            try (IndexReader reader = this.indexProxy.newReader();){
                Register.DoubleLongRegister sample = Registers.newDoubleLongRegister();
                long indexSize = reader.sampleIndex((Register.DoubleLong.Out)sample);
                if (this.indexProxy.getState() == InternalIndexState.ONLINE) {
                    long unique = sample.readFirst();
                    long sampleSize = sample.readSecond();
                    this.storeView.replaceIndexCounts(this.indexDescriptor, unique, sampleSize, indexSize);
                    durationLogger.markAsFinished();
                    this.log.info(String.format("Sampled index %s with %d unique values in sample of avg size %d taken from index containing %d entries", this.indexUserDescription, unique, sampleSize, indexSize));
                } else {
                    durationLogger.markAsAborted("Index no longer ONLINE");
                }
            }
            catch (IndexNotFoundKernelException e) {
                durationLogger.markAsAborted("Attempted to sample missing/already deleted index " + this.indexUserDescription);
            }
        }
    }
}

