/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.StoreLockException;

@Deprecated
public class StoreLocker {
    public static final String STORE_LOCK_FILENAME = "store_lock";
    private final FileSystemAbstraction fileSystemAbstraction;
    private FileLock storeLockFileLock;
    private StoreChannel storeLockFileChannel;

    public StoreLocker(FileSystemAbstraction fileSystemAbstraction) {
        this.fileSystemAbstraction = fileSystemAbstraction;
    }

    public void checkLock(File storeDir) throws StoreLockException {
        File storeLockFile = new File(storeDir, STORE_LOCK_FILENAME);
        try {
            if (!this.fileSystemAbstraction.fileExists(storeLockFile)) {
                this.fileSystemAbstraction.mkdirs(storeLockFile.getParentFile());
            }
        }
        catch (IOException e) {
            String message = "Unable to create path for store dir: " + storeDir;
            throw this.storeLockException(message, e);
        }
        try {
            this.storeLockFileChannel = this.fileSystemAbstraction.open(storeLockFile, "rw");
            this.storeLockFileLock = this.storeLockFileChannel.tryLock();
            if (this.storeLockFileLock == null) {
                String message = "Store and its lock file has been locked by another process: " + storeLockFile;
                throw this.storeLockException(message, null);
            }
        }
        catch (IOException | OverlappingFileLockException e) {
            String message = "Unable to obtain lock on store lock file: " + storeLockFile;
            throw this.storeLockException(message, e);
        }
    }

    private StoreLockException storeLockException(String message, Exception e) {
        String help = "Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)";
        return new StoreLockException(message + ". " + help, e);
    }

    public void release() throws IOException {
        if (this.storeLockFileLock != null) {
            this.storeLockFileLock.release();
            this.storeLockFileLock = null;
        }
        if (this.storeLockFileChannel != null) {
            this.storeLockFileChannel.close();
            this.storeLockFileChannel = null;
        }
    }
}

