/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.util.DN;

public final class RDN
implements Serializable {
    static final long serialVersionUID = 7895454691174650321L;
    private String[] m_type = null;
    private String[] m_value = null;
    private boolean m_ismultivalued = false;
    private static Hashtable m_attributehash = new Hashtable();
    public static final String[] _cesAttributes = new String[]{"adminurl", "altserver", "automountinformation", "bootfile", "bootparameter", "cirbindcredentials", "generation", "homedirectory", "internationalisdnnumber", "labeleduri", "membercertificatedescription", "membernisnetgroup", "memberuid", "memberurl", "nismapentry", "nisnetgrouptriple", "nsaddressbooksyncurl", "presentationaddress", "ref", "replicaentryfilter", "searchguide", "subtreeaci", "vlvfilter", "vlvname", "x121address"};
    public static final String CES_SYNTAX = "1.3.6.1.4.1.1466.115.121.1.26";

    public RDN(String rdn) {
        String neutralRDN = RDN.neutralizeEscapes(rdn);
        if (neutralRDN == null) {
            return;
        }
        int index = neutralRDN.indexOf("=");
        if (index <= 0) {
            return;
        }
        Vector<String> values = new Vector<String>();
        Vector<String> types = new Vector<String>();
        types.addElement(rdn.substring(0, index).trim());
        int next_plus = neutralRDN.indexOf(43, index);
        while (next_plus != -1) {
            this.m_ismultivalued = true;
            values.addElement(rdn.substring(index + 1, next_plus).trim());
            index = neutralRDN.indexOf("=", next_plus + 1);
            if (index == -1) {
                return;
            }
            types.addElement(rdn.substring(next_plus + 1, index).trim());
            next_plus = neutralRDN.indexOf(43, index);
        }
        values.addElement(rdn.substring(index + 1).trim());
        this.m_type = new String[types.size()];
        this.m_value = new String[values.size()];
        for (int i = 0; i < types.size(); ++i) {
            this.m_type[i] = (String)types.elementAt(i);
            if (!this.isValidType(this.m_type[i])) {
                this.m_value = null;
                this.m_type = null;
                return;
            }
            this.m_value[i] = (String)values.elementAt(i);
            if (this.isValidValue(this.m_value[i])) continue;
            this.m_value = null;
            this.m_type = null;
            return;
        }
    }

    static String neutralizeEscapes(String rdn) {
        int i;
        if (rdn == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(rdn);
        boolean quoteOn = false;
        for (i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\\') continue;
            sb.setCharAt(i, 'x');
            if (i < sb.length() - 1) {
                sb.setCharAt(i + 1, 'x');
                continue;
            }
            return null;
        }
        for (i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\"') {
                quoteOn = !quoteOn;
                continue;
            }
            if (!quoteOn) continue;
            sb.setCharAt(i, 'x');
        }
        return quoteOn ? null : sb.toString();
    }

    private boolean isValidType(String type) {
        if (type == null || type.length() < 1) {
            return false;
        }
        for (int i = 0; i < type.length(); ++i) {
            for (int j = 0; j < DN.ESCAPED_CHAR.length; ++j) {
                if (type.charAt(i) != DN.ESCAPED_CHAR[j]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidValue(String val) {
        if (val == null || val.length() < 1) {
            return false;
        }
        int cnt = 0;
        int i = 0;
        while (i >= 0 && i < val.length()) {
            if ((i = val.indexOf(34, i)) < 0) continue;
            if (i == 0 || val.charAt(i - 1) != '\\') {
                ++cnt;
            }
            ++i;
        }
        if (cnt == 0) {
            return true;
        }
        if (cnt != 2) {
            return false;
        }
        return val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"';
    }

    public String[] explodeRDN(boolean noType) {
        if (this.m_type == null) {
            return null;
        }
        String[] str = new String[]{noType ? this.getValue() : this.toString()};
        return str;
    }

    public String getType() {
        if (this.m_type != null && this.m_type.length > 0) {
            return this.m_type[0];
        }
        return null;
    }

    public String[] getTypes() {
        return this.m_type;
    }

    public String getValue() {
        if (this.m_value != null && this.m_value.length > 0) {
            return this.m_value[0];
        }
        return null;
    }

    public String[] getValues() {
        return this.m_value;
    }

    public boolean isMultivalued() {
        return this.m_ismultivalued;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; this.m_type != null && i < this.m_type.length; ++i) {
            if (i != 0) {
                buf.append(" + ");
            }
            buf.append(this.m_type[i] + "=" + this.m_value[i]);
        }
        return buf.toString();
    }

    public static boolean isRDN(String rdn) {
        RDN newrdn = new RDN(rdn);
        return newrdn.getTypes() != null && newrdn.getValues() != null;
    }

    public boolean equals(RDN rdn) {
        String[] this_types = (String[])this.getTypes().clone();
        String[] this_values = (String[])this.getValues().clone();
        String[] rdn_types = (String[])rdn.getTypes().clone();
        String[] rdn_values = (String[])rdn.getValues().clone();
        if (this_types.length != rdn_types.length) {
            return false;
        }
        this.sortTypesAndValues(this_types, this_values);
        this.sortTypesAndValues(rdn_types, rdn_values);
        for (int i = 0; i < this_types.length; ++i) {
            if (!this_types[i].equalsIgnoreCase(rdn_types[i])) {
                return false;
            }
            if (!(CES_SYNTAX.equals(RDN.getAttributeSyntax(this_types[i])) ? !this_values[i].equals(rdn_values[i]) : !this_values[i].equalsIgnoreCase(rdn_values[i]))) continue;
            return false;
        }
        return true;
    }

    void sortTypesAndValues(String[] types, String[] values) {
        do {
            boolean no_changes = true;
            for (int i = 0; i < types.length - 1; ++i) {
                if (types[i].toLowerCase().compareTo(types[i + 1].toLowerCase()) <= 0) continue;
                String tmp_type = types[i];
                String tmp_value = values[i];
                types[i] = types[i + 1];
                values[i] = values[i + 1];
                types[i + 1] = tmp_type;
                values[i + 1] = tmp_value;
                no_changes = false;
            }
            no_changes = false;
        } while (false);
    }

    public static void registerAttributeSyntax(String attr, String oid) {
        m_attributehash.put(attr.toLowerCase(), oid);
    }

    public static void unregisterAttributeSyntax(String attr) {
        m_attributehash.remove(attr.toLowerCase());
    }

    public static String getAttributeSyntax(String attr) {
        return (String)m_attributehash.get(attr.toLowerCase());
    }

    public static String[] getAttributesForSyntax(String oid) {
        Enumeration enumeration = m_attributehash.keys();
        Vector<String> key_v = new Vector<String>();
        String tmp_str = null;
        while (enumeration.hasMoreElements()) {
            tmp_str = (String)enumeration.nextElement();
            if (!oid.equals((String)m_attributehash.get(tmp_str))) continue;
            key_v.addElement(tmp_str);
        }
        String[] str = new String[key_v.size()];
        for (int i = 0; i < str.length; ++i) {
            str[i] = new String((String)key_v.elementAt(i));
        }
        return str;
    }

    static {
        for (int i = 0; i < _cesAttributes.length; ++i) {
            RDN.registerAttributeSyntax(_cesAttributes[i], CES_SYNTAX);
        }
    }
}

