/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.MimeEncoder;

public final class MimeBase64Encoder
extends MimeEncoder {
    static final long serialVersionUID = 8781620079813078315L;
    private int buf = 0;
    private int buf_bytes = 0;
    private byte[] line = new byte[74];
    private int line_length = 0;
    private static final byte[] crlf = "\r\n".getBytes();
    private static final char[] map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private final void encode_token() {
        int i = this.line_length;
        this.line[i] = (byte)map[0x3F & this.buf >> 18];
        this.line[i + 1] = (byte)map[0x3F & this.buf >> 12];
        this.line[i + 2] = (byte)map[0x3F & this.buf >> 6];
        this.line[i + 3] = (byte)map[0x3F & this.buf];
        this.line_length += 4;
        this.buf = 0;
        this.buf_bytes = 0;
    }

    private final void encode_partial_token() {
        int i = this.line_length;
        this.line[i] = (byte)map[0x3F & this.buf >> 18];
        this.line[i + 1] = (byte)map[0x3F & this.buf >> 12];
        this.line[i + 2] = this.buf_bytes == 1 ? 61 : (byte)map[0x3F & this.buf >> 6];
        this.line[i + 3] = this.buf_bytes <= 2 ? 61 : (byte)map[0x3F & this.buf];
        this.line_length += 4;
        this.buf = 0;
        this.buf_bytes = 0;
    }

    private final void flush_line(ByteBuf out) {
        out.append(this.line, 0, this.line_length);
        this.line_length = 0;
    }

    public final void translate(ByteBuf in, ByteBuf out) {
        int i;
        byte[] inb = in.toBytes();
        int in_length = in.length();
        for (i = 0; i < in_length; ++i) {
            this.buf = this.buf_bytes == 0 ? this.buf & 0xFFFF | inb[i] << 16 : (this.buf_bytes == 1 ? this.buf & 0xFF00FF | inb[i] << 8 & 0xFFFF : this.buf & 0xFFFF00 | inb[i] & 0xFF);
            if (++this.buf_bytes == 3) {
                this.encode_token();
                if (this.line_length >= 72) {
                    this.flush_line(out);
                }
            }
            if (i != in_length - 1) continue;
            if (this.buf_bytes > 0 && this.buf_bytes < 3) {
                this.encode_partial_token();
            }
            if (this.line_length <= 0) continue;
            this.flush_line(out);
        }
        for (i = 0; i < this.line.length; ++i) {
            this.line[i] = 0;
        }
    }

    public final void eof(ByteBuf out) {
        if (this.buf_bytes != 0) {
            this.encode_partial_token();
        }
        this.flush_line(out);
        for (int i = 0; i < this.line.length; ++i) {
            this.line[i] = 0;
        }
    }
}

