/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.controls.LDAPEntryChangeControl;

public class LDAPPersistSearchControl
extends LDAPControl {
    private int m_changeTypes = 1;
    private boolean m_changesOnly = false;
    private boolean m_returnECs = false;
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int MODIFY = 4;
    public static final int MODDN = 8;
    public static final String PERSISTENTSEARCH = "2.16.840.1.113730.3.4.3";

    public LDAPPersistSearchControl() {
        super(PERSISTENTSEARCH, true, null);
    }

    public LDAPPersistSearchControl(int changeTypes, boolean changesOnly, boolean returnControls, boolean isCritical) {
        super(PERSISTENTSEARCH, isCritical, null);
        this.m_value = this.createPersistSearchSpecification(changeTypes, changesOnly, returnControls);
        this.m_changeTypes = changeTypes;
        this.m_changesOnly = changesOnly;
        this.m_returnECs = returnControls;
    }

    public int getChangeTypes() {
        return this.m_changeTypes;
    }

    public boolean getChangesOnly() {
        return this.m_changesOnly;
    }

    public boolean getReturnControls() {
        return this.m_returnECs;
    }

    public void setChangeTypes(int types) {
        this.m_changeTypes = types;
    }

    public void setChangesOnly(boolean changesOnly) {
        this.m_changesOnly = changesOnly;
    }

    public void setReturnControls(boolean returnControls) {
        this.m_returnECs = returnControls;
    }

    public LDAPEntryChangeControl parseResponse(byte[] c) {
        LDAPEntryChangeControl con = new LDAPEntryChangeControl();
        ByteArrayInputStream inStream = new ByteArrayInputStream(c);
        BERSequence seq = new BERSequence();
        JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
        int[] numRead = new int[]{0};
        try {
            BERInteger num;
            BERSequence s = (BERSequence)BERElement.getElement(decoder, inStream, numRead);
            BEREnumerated bEREnumerated = (BEREnumerated)s.elementAt(0);
            con.setChangeType(bEREnumerated.getValue());
            if (s.size() > 1) {
                if (s.elementAt(1) instanceof BEROctetString) {
                    BEROctetString str = (BEROctetString)s.elementAt(1);
                    con.setPreviousDN(new String(str.getValue(), "UTF8"));
                } else if (s.elementAt(1) instanceof BERInteger) {
                    num = (BERInteger)s.elementAt(1);
                    con.setChangeNumber(num.getValue());
                }
            }
            if (s.size() > 2) {
                num = (BERInteger)s.elementAt(2);
                con.setChangeNumber(num.getValue());
            }
        }
        catch (Exception e) {
            return null;
        }
        return con;
    }

    public static LDAPEntryChangeControl parseResponse(LDAPControl[] controls) {
        LDAPPersistSearchControl con = new LDAPPersistSearchControl();
        for (int i = 0; controls != null && i < controls.length; ++i) {
            if (!controls[i].getID().equals("2.16.840.1.113730.3.4.7")) continue;
            return con.parseResponse(controls[i].getValue());
        }
        return null;
    }

    private byte[] createPersistSearchSpecification(int changeTypes, boolean changesOnly, boolean returnECs) {
        BERSequence seq = new BERSequence();
        seq.addElement(new BERInteger(changeTypes));
        seq.addElement(new BERBoolean(changesOnly));
        seq.addElement(new BERBoolean(returnECs));
        return this.flattenBER(seq);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{PersistSearchCtrl:");
        sb.append(" isCritical=");
        sb.append(this.isCritical());
        sb.append(" returnEntryChangeCtrls=");
        sb.append(this.m_returnECs);
        sb.append(" changesOnly=");
        sb.append(this.m_changesOnly);
        sb.append(" changeTypes=");
        sb.append(LDAPPersistSearchControl.typesToString(this.m_changeTypes));
        sb.append("}");
        return sb.toString();
    }

    static String typesToString(int changeTypes) {
        String types = "";
        if ((changeTypes & 1) != 0) {
            types = types + (types.length() > 0 ? "+ADD" : "ADD");
        }
        if ((changeTypes & 2) != 0) {
            types = types + (types.length() > 0 ? "+DEL" : "DEL");
        }
        if ((changeTypes & 4) != 0) {
            types = types + (types.length() > 0 ? "+MOD" : "MOD");
        }
        if ((changeTypes & 8) != 0) {
            types = types + (types.length() > 0 ? "+MODDN" : "MODDN");
        }
        return types;
    }
}

