/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.controls.LDAPPersistSearchControl;

public class LDAPEntryChangeControl
extends LDAPControl {
    private int m_changeNumber = -1;
    private int m_changeTypes = -1;
    private String m_previousDN = null;
    public static final String ENTRYCHANGED = "2.16.840.1.113730.3.4.7";

    public LDAPEntryChangeControl() {
        super(ENTRYCHANGED, false, null);
    }

    public LDAPEntryChangeControl(String oid, boolean critical, byte[] value) throws LDAPException, IOException {
        super(ENTRYCHANGED, false, value);
        BERInteger num;
        if (!oid.equals(ENTRYCHANGED)) {
            throw new LDAPException("oid must be LDAPEntryChangeControl.ENTRYCHANGED", 89);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(this.m_value);
        BERSequence seq = new BERSequence();
        JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
        int[] numRead = new int[]{0};
        BERSequence s = (BERSequence)BERElement.getElement(decoder, inStream, numRead);
        BEREnumerated bEREnumerated = (BEREnumerated)s.elementAt(0);
        this.m_changeTypes = bEREnumerated.getValue();
        if (s.size() > 1) {
            if (s.elementAt(1) instanceof BEROctetString) {
                BEROctetString str = (BEROctetString)s.elementAt(1);
                try {
                    this.m_previousDN = new String(str.getValue(), "UTF8");
                }
                catch (UnsupportedEncodingException e) {}
            } else if (s.elementAt(1) instanceof BERInteger) {
                num = (BERInteger)s.elementAt(1);
                this.m_changeNumber = num.getValue();
            }
        }
        if (s.size() > 2) {
            num = (BERInteger)s.elementAt(2);
            this.m_changeNumber = num.getValue();
        }
    }

    public void setChangeNumber(int num) {
        this.m_changeNumber = num;
    }

    public void setChangeType(int num) {
        this.m_changeTypes = num;
    }

    public void setPreviousDN(String dn) {
        this.m_previousDN = dn;
    }

    public int getChangeNumber() {
        return this.m_changeNumber;
    }

    public int getChangeType() {
        return this.m_changeTypes;
    }

    public String getPreviousDN() {
        return this.m_previousDN;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{EntryChangedCtrl:");
        sb.append(" isCritical=");
        sb.append(this.isCritical());
        sb.append(" changeTypes=");
        sb.append(LDAPPersistSearchControl.typesToString(this.m_changeTypes));
        sb.append(" previousDN=");
        sb.append(this.m_previousDN);
        sb.append(" changeNumber=");
        sb.append(this.m_changeNumber);
        sb.append("}");
        return sb.toString();
    }
}

