/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import java.io.IOException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPSearchResultReference
implements JDAPProtocolOp {
    protected String[] m_urls = null;
    protected BERElement m_element = null;

    public JDAPSearchResultReference(BERElement element) throws IOException {
        this.m_element = element;
        BERSequence seq = (BERSequence)((BERTag)element).getValue();
        if (seq.size() < 0) {
            return;
        }
        this.m_urls = new String[seq.size()];
        for (int i = 0; i < seq.size(); ++i) {
            BEROctetString o = (BEROctetString)seq.elementAt(i);
            this.m_urls[i] = new String(o.getValue(), "UTF8");
        }
    }

    public int getType() {
        return 19;
    }

    public BERElement getBERElement() {
        return this.m_element;
    }

    public String[] getUrls() {
        return this.m_urls;
    }

    public String toString() {
        String urls = "";
        if (this.m_urls != null) {
            for (int i = 0; i < this.m_urls.length; ++i) {
                if (i != 0) {
                    urls = urls + ",";
                }
                urls = urls + this.m_urls[i];
            }
        }
        return "SearchResultReference " + urls;
    }
}

