/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import netscape.ldap.LDAPAttribute;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPBaseDNRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPAddRequest
extends JDAPBaseDNRequest
implements JDAPProtocolOp {
    protected String m_dn = null;
    protected LDAPAttribute[] m_attrs = null;

    public JDAPAddRequest(String dn, LDAPAttribute[] attrs) {
        this.m_dn = dn;
        this.m_attrs = attrs;
    }

    public int getType() {
        return 8;
    }

    public void setBaseDN(String basedn) {
        this.m_dn = basedn;
    }

    public String getBaseDN() {
        return this.m_dn;
    }

    public BERElement getBERElement() {
        BERSequence seq = new BERSequence();
        seq.addElement(new BEROctetString(this.m_dn));
        BERSequence attrs_list = new BERSequence();
        for (int i = 0; i < this.m_attrs.length; ++i) {
            attrs_list.addElement(this.m_attrs[i].getBERElement());
        }
        seq.addElement(attrs_list);
        BERTag element = new BERTag(104, seq, true);
        return element;
    }

    public String getParamString() {
        String s = "";
        for (int i = 0; i < this.m_attrs.length; ++i) {
            if (i != 0) {
                s = s + " ";
            }
            s = s + this.m_attrs[i].toString();
        }
        return "{entry='" + this.m_dn + "', attrs='" + s + "'}";
    }

    public String toString() {
        return "AddRequest " + this.getParamString();
    }
}

