/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BEROctetString
extends BERElement {
    private byte[] m_value = null;

    public BEROctetString(String buffer) {
        if (buffer == null) {
            return;
        }
        try {
            this.m_value = buffer.getBytes("UTF8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public BEROctetString(byte[] buffer) {
        this.m_value = buffer;
    }

    public BEROctetString(byte[] buffer, int start, int end) {
        this.m_value = new byte[end - start];
        for (int i = 0; i < end - start; ++i) {
            this.m_value[i] = buffer[start + i];
        }
    }

    public BEROctetString(BERTagDecoder decoder, InputStream stream, int[] bytes_read) throws IOException {
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        int[] component_length = new int[1];
        BERElement element = null;
        if (contents_length == -1) {
            do {
                component_length[0] = 0;
                element = BEROctetString.getElement(decoder, stream, component_length);
                if (element == null) continue;
                BEROctetString octet_element = (BEROctetString)element;
                byte[] octet_buffer = octet_element.getValue();
                if (this.m_value == null) {
                    this.m_value = new byte[octet_buffer.length];
                    System.arraycopy(octet_buffer, 0, this.m_value, 0, octet_buffer.length);
                    continue;
                }
                byte[] new_buffer = new byte[this.m_value.length + octet_buffer.length];
                System.arraycopy(this.m_value, 0, new_buffer, 0, this.m_value.length);
                System.arraycopy(octet_buffer, 0, new_buffer, this.m_value.length, octet_buffer.length);
                this.m_value = new_buffer;
            } while (element != null);
        } else {
            bytes_read[0] = bytes_read[0] + contents_length;
            this.m_value = new byte[contents_length];
            int cnt = 0;
            for (int idx = 0; idx < contents_length; idx += cnt) {
                cnt = stream.read(this.m_value, idx, contents_length - idx);
            }
        }
    }

    public BEROctetString(InputStream stream, int[] bytes_read) throws IOException {
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        if (contents_length > 0) {
            this.m_value = new byte[contents_length];
            for (int i = 0; i < contents_length; ++i) {
                this.m_value[i] = (byte)stream.read();
            }
            bytes_read[0] = bytes_read[0] + contents_length;
        }
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(4);
        if (this.m_value == null) {
            BEROctetString.sendDefiniteLength(stream, 0);
        } else {
            BEROctetString.sendDefiniteLength(stream, this.m_value.length);
            stream.write(this.m_value, 0, this.m_value.length);
        }
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public int getType() {
        return 4;
    }

    public String toString() {
        if (this.m_value == null) {
            return "OctetString (null)";
        }
        StringBuffer octets = new StringBuffer("OctetString {");
        for (int i = 0; i < this.m_value.length; ++i) {
            if (i != 0) {
                octets.append(' ');
            }
            octets.append(this.byteToHexString(this.m_value[i]));
        }
        octets.append('}');
        return octets.toString();
    }
}

