/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BERBitString
extends BERElement {
    private BitSet m_value;
    private int m_value_num_bits;

    public BERBitString(BitSet value) {
        this.m_value = value;
    }

    public BERBitString(BERTagDecoder decoder, InputStream stream, int[] bytes_read) throws IOException {
        int contents_length;
        int[] component_length = new int[1];
        BERElement element = null;
        if (contents_length == -1) {
            component_length[0] = 0;
            element = BERBitString.getElement(decoder, stream, component_length);
            if (element != null) {
                BERBitString bit_string_element = (BERBitString)element;
                BitSet new_bit_set = new BitSet(this.m_value_num_bits + bit_string_element.getSize());
                for (int i = 0; i < this.m_value_num_bits; ++i) {
                    if (!this.m_value.get(i)) continue;
                    new_bit_set.set(i);
                }
                for (int j = 0; j < bit_string_element.getSize(); ++j) {
                    if (!bit_string_element.getValue().get(j)) continue;
                    new_bit_set.set(this.m_value_num_bits + j);
                }
                this.m_value = new_bit_set;
                this.m_value_num_bits += bit_string_element.getSize();
            }
            while (element != null) {
            }
        } else {
            bytes_read[0] = bytes_read[0] + contents_length;
            for (contents_length = BERElement.readLengthOctets(stream, bytes_read); contents_length > 0; contents_length -= component_length[0]) {
                component_length[0] = 0;
                element = BERBitString.getElement(decoder, stream, component_length);
                if (element == null) continue;
                BERBitString bit_string_element = (BERBitString)element;
                BitSet new_bit_set = new BitSet(this.m_value_num_bits + bit_string_element.getSize());
                for (int i = 0; i < this.m_value_num_bits; ++i) {
                    if (!this.m_value.get(i)) continue;
                    new_bit_set.set(i);
                }
                for (int j = 0; j < bit_string_element.getSize(); ++j) {
                    if (!bit_string_element.getValue().get(j)) continue;
                    new_bit_set.set(this.m_value_num_bits + j);
                }
                this.m_value = new_bit_set;
                this.m_value_num_bits += bit_string_element.getSize();
            }
        }
    }

    public BERBitString(InputStream stream, int[] bytes_read) throws IOException {
        int octet;
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        int last_unused_bits = stream.read();
        bytes_read[0] = bytes_read[0] + 1;
        this.m_value_num_bits = (--contents_length - 1) * 8 + (8 - last_unused_bits);
        this.m_value = new BitSet();
        int bit_num = 0;
        for (int i = 0; i < contents_length - 1; ++i) {
            octet = stream.read();
            int mask = 128;
            for (int j = 0; j < 8; ++j) {
                if ((octet & mask) > 0) {
                    this.m_value.set(bit_num);
                } else {
                    this.m_value.clear(bit_num);
                }
                ++bit_num;
                mask /= 2;
            }
        }
        octet = stream.read();
        int mask = 128;
        for (int j = 0; j < 8 - last_unused_bits; ++j) {
            if ((octet & mask) > 0) {
                this.m_value.set(bit_num);
            } else {
                this.m_value.clear(bit_num);
            }
            ++bit_num;
            mask /= 2;
        }
        bytes_read[0] = bytes_read[0] + contents_length;
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(3);
        int num_bits = this.m_value_num_bits;
        int last_unused_bits = 8 - num_bits % 8;
        int num_content_octets = num_bits / 8 + 1;
        if (last_unused_bits > 0) {
            ++num_content_octets;
        }
        stream.write(num_content_octets);
        stream.write(last_unused_bits);
        for (int i = 0; i < num_bits / 8; ++i) {
            int new_octet = 0;
            int bit = 128;
            for (int j = 0; j < 8; ++j) {
                if (this.m_value.get(i * 8 + j)) {
                    new_octet += bit;
                }
                bit /= 2;
            }
            stream.write(new_octet);
        }
        if (last_unused_bits > 0) {
            int new_octet = 0;
            int bit = 128;
            for (int j = 0; j < last_unused_bits; ++j) {
                if (this.m_value.get(num_bits / 8 * 8 + j)) {
                    new_octet += bit;
                }
                bit /= 2;
            }
            stream.write(new_octet);
        }
    }

    public BitSet getValue() {
        return this.m_value;
    }

    public int getSize() {
        return this.m_value_num_bits;
    }

    public int getType() {
        return 3;
    }

    public String toString() {
        int octet;
        String hex_string = "";
        int num_bits = this.m_value_num_bits;
        for (int i = 0; i < num_bits / 8; ++i) {
            octet = 0;
            int bit = 128;
            for (int j = 0; j < 8; ++j) {
                if (this.m_value.get(i * 8 + j)) {
                    octet += bit;
                }
                bit /= 2;
            }
            hex_string = hex_string + " " + (byte)octet;
        }
        int bit = 128;
        octet = 0;
        for (int k = 0; k < num_bits - num_bits / 8; ++k) {
            if (this.m_value.get(num_bits / 8 * 8 + k)) {
                octet += bit;
            }
            bit /= 2;
        }
        hex_string = hex_string + " " + (byte)octet;
        return "Bitstring {" + hex_string + " }";
    }
}

