/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPNameFormSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = 1665316286199590403L;
    private Vector must = new Vector();
    private Vector may = new Vector();
    private String objectClass = null;
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;

    public LDAPNameFormSchema(String name, String oid, String description, boolean obsolete, String objectClass, String[] required, String[] optional) {
        super(name, oid, description, null);
        int i;
        this.attrName = "nameforms";
        if (obsolete) {
            this.setQualifier("OBSOLETE", "");
        }
        this.objectClass = objectClass;
        if (required != null) {
            for (i = 0; i < required.length; ++i) {
                this.must.addElement(required[i]);
            }
        }
        if (optional != null) {
            for (i = 0; i < optional.length; ++i) {
                this.may.addElement(optional[i]);
            }
        }
    }

    public LDAPNameFormSchema(String raw) {
        this.attrName = "objectclasses";
        this.parseValue(raw);
        Object o = this.properties.get("MAY");
        if (o != null) {
            if (o instanceof Vector) {
                this.may = (Vector)o;
            } else {
                this.may.addElement(o);
            }
        }
        if ((o = this.properties.get("MUST")) != null) {
            if (o instanceof Vector) {
                this.must = (Vector)o;
            } else {
                this.must.addElement(o);
            }
        }
        if ((o = this.properties.get("OC")) != null) {
            this.objectClass = (String)o;
        }
    }

    public String[] getRequiredNamingAttributes() {
        Object[] vals = new String[this.must.size()];
        this.must.copyInto(vals);
        return vals;
    }

    public String[] getOptionalNamingAttributes() {
        Object[] vals = new String[this.may.size()];
        this.may.copyInto(vals);
        return vals;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    String getValue(boolean quotingBug) {
        String s = this.getValuePrefix();
        String val = this.getOptionalValues(NOVALS);
        if (val.length() > 0) {
            s = s + val + ' ';
        }
        s = s + "OC " + this.objectClass + ' ';
        if (this.must.size() > 0) {
            s = s + "MUST " + this.vectorToList(this.must);
            s = s + ' ';
        }
        if (this.may.size() > 0) {
            s = s + "MAY " + this.vectorToList(this.may);
            s = s + ' ';
        }
        if ((val = this.getCustomValues()).length() > 0) {
            s = s + val + ' ';
        }
        s = s + ')';
        return s;
    }

    public String toString() {
        int i;
        String s = "Name: " + this.name + "; OID: " + this.oid;
        s = s + "; Description: " + this.description + "; Required: ";
        String[] vals = this.getRequiredNamingAttributes();
        for (i = 0; i < vals.length; ++i) {
            if (i > 0) {
                s = s + ", ";
            }
            s = s + vals[i];
        }
        s = s + "; Optional: ";
        vals = this.getOptionalNamingAttributes();
        for (i = 0; i < vals.length; ++i) {
            if (i > 0) {
                s = s + ", ";
            }
            s = s + vals[i];
        }
        if (this.isObsolete()) {
            s = s + "; OBSOLETE";
        }
        s = s + this.getQualifierString(IGNOREVALS);
        return s;
    }

    protected String vectorToList(Vector vals) {
        String val = "( ";
        for (int i = 0; i < vals.size(); ++i) {
            val = val + (String)vals.elementAt(i) + ' ';
            if (i >= vals.size() - 1) continue;
            val = val + "$ ";
        }
        val = val + ')';
        return val;
    }

    static {
        for (int i = 0; i < NOVALS.length; ++i) {
            novalsTable.put(NOVALS[i], NOVALS[i]);
        }
        IGNOREVALS = new String[]{"MUST", "MAY", "OBJECTCLASS", "OBSOLETE"};
    }
}

