/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERSet;

public class LDAPAttribute
implements Serializable {
    static final long serialVersionUID = -4594745735452202600L;
    private String name = null;
    private byte[] nameBuf = null;
    private Object[] values = new Object[0];

    public LDAPAttribute(LDAPAttribute attr) {
        this.name = attr.name;
        this.nameBuf = attr.nameBuf;
        this.values = new Object[attr.values.length];
        for (int i = 0; i < attr.values.length; ++i) {
            this.values[i] = new byte[((byte[])attr.values[i]).length];
            System.arraycopy((byte[])attr.values[i], 0, (byte[])this.values[i], 0, ((byte[])attr.values[i]).length);
        }
    }

    public LDAPAttribute(String attrName) {
        this.name = attrName;
    }

    public LDAPAttribute(String attrName, byte[] attrValue) {
        this.name = attrName;
        this.addValue(attrValue);
    }

    public LDAPAttribute(String attrName, String attrValue) {
        this.name = attrName;
        this.addValue(attrValue);
    }

    public LDAPAttribute(String attrName, String[] attrValues) {
        this.name = attrName;
        if (attrValues != null) {
            this.setValues(attrValues);
        }
    }

    public LDAPAttribute(BERElement element) throws IOException {
        BERSequence seq = (BERSequence)element;
        BEROctetString type = (BEROctetString)seq.elementAt(0);
        this.nameBuf = type.getValue();
        BERSet set = (BERSet)seq.elementAt(1);
        if (set.size() > 0) {
            Object[] vals = new Object[set.size()];
            for (int i = 0; i < set.size(); ++i) {
                vals[i] = ((BEROctetString)set.elementAt(i)).getValue();
                if (vals[i] != null) continue;
                vals[i] = new byte[0];
            }
            this.setValues(vals);
        }
    }

    public int size() {
        return this.values.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getStringValues() {
        Vector<String> v = new Vector<String>();
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] != null) {
                        v.addElement(new String((byte[])this.values[i], "UTF8"));
                        continue;
                    }
                    v.addElement(new String(""));
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStringValueArray() {
        String[] s = new String[this.values.length];
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                for (int i = 0; i < this.values.length; ++i) {
                    s[i] = this.values[i] != null ? new String((byte[])this.values[i], "UTF8") : new String("");
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getByteValues() {
        Vector<Object> v = new Vector<Object>();
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] != null) {
                    v.addElement(this.values[i]);
                    continue;
                }
                v.addElement(new byte[0]);
            }
        }
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getByteValueArray() {
        byte[][] b = new byte[this.values.length][];
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                for (int i = 0; i < this.values.length; ++i) {
                    b[i] = new byte[((byte[])this.values[i]).length];
                    System.arraycopy((byte[])this.values[i], 0, b[i], 0, ((byte[])this.values[i]).length);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return b;
    }

    public String getName() {
        if (this.name == null && this.nameBuf != null) {
            try {
                this.name = new String(this.nameBuf, "UTF8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.name;
    }

    public static String[] getSubtypes(String attrName) {
        StringTokenizer st = new StringTokenizer(attrName, ";");
        if (st.hasMoreElements()) {
            st.nextElement();
            String[] subtypes = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreElements()) {
                subtypes[i++] = (String)st.nextElement();
            }
            return subtypes;
        }
        return null;
    }

    public String[] getSubtypes() {
        return LDAPAttribute.getSubtypes(this.getName());
    }

    public String getLangSubtype() {
        String[] subTypes = this.getSubtypes();
        if (subTypes != null) {
            for (int i = 0; i < subTypes.length; ++i) {
                if (subTypes[i].length() < 5 || !subTypes[i].substring(0, 5).equalsIgnoreCase("lang-")) continue;
                return subTypes[i];
            }
        }
        return null;
    }

    public static String getBaseName(String attrName) {
        String basename = attrName;
        StringTokenizer st = new StringTokenizer(attrName, ";");
        if (st.hasMoreElements()) {
            basename = (String)st.nextElement();
        }
        return basename;
    }

    public String getBaseName() {
        return LDAPAttribute.getBaseName(this.getName());
    }

    public boolean hasSubtype(String subtype) {
        String[] mytypes = this.getSubtypes();
        for (int i = 0; i < mytypes.length; ++i) {
            if (!subtype.equalsIgnoreCase(mytypes[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasSubtypes(String[] subtypes) {
        for (int i = 0; i < subtypes.length; ++i) {
            if (this.hasSubtype(subtypes[i])) continue;
            return false;
        }
        return true;
    }

    public synchronized void addValue(String attrValue) {
        if (attrValue != null) {
            try {
                byte[] b = attrValue.getBytes("UTF8");
                this.addValue(b);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void setValues(String[] attrValues) {
        Object[] vals;
        if (attrValues != null) {
            vals = new Object[attrValues.length];
            for (int i = 0; i < vals.length; ++i) {
                try {
                    vals[i] = attrValues[i].getBytes("UTF8");
                    continue;
                }
                catch (Throwable x) {
                    vals[i] = new byte[0];
                }
            }
        } else {
            vals = new Object[]{};
        }
        this.setValues(vals);
    }

    public synchronized void addValue(byte[] attrValue) {
        if (attrValue != null) {
            Object[] vals = new Object[this.values.length + 1];
            for (int i = 0; i < this.values.length; ++i) {
                vals[i] = this.values[i];
            }
            vals[this.values.length] = attrValue;
            this.values = vals;
        }
    }

    protected synchronized void setValues(Object[] attrValues) {
        this.values = attrValues;
    }

    public synchronized void removeValue(String attrValue) {
        if (attrValue != null) {
            try {
                byte[] b = attrValue.getBytes("UTF8");
                this.removeValue(b);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public synchronized void removeValue(byte[] attrValue) {
        if (attrValue == null || this.values == null || this.values.length < 1) {
            return;
        }
        int ind = -1;
        for (int i = 0; i < this.values.length; ++i) {
            if (!LDAPAttribute.equalValue(attrValue, (byte[])this.values[i])) continue;
            ind = i;
            break;
        }
        if (ind >= 0) {
            Object[] vals = new Object[this.values.length - 1];
            int j = 0;
            for (int i = 0; i < this.values.length; ++i) {
                if (i == ind) continue;
                vals[j++] = this.values[i];
            }
            this.values = vals;
        }
    }

    private static boolean equalValue(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public BERElement getBERElement() {
        try {
            BERSequence seq = new BERSequence();
            seq.addElement(new BEROctetString(this.getName()));
            BERSet set = new BERSet();
            for (int i = 0; i < this.values.length; ++i) {
                set.addElement(new BEROctetString((byte[])this.values[i]));
            }
            seq.addElement(set);
            return seq;
        }
        catch (IOException e) {
            return null;
        }
    }

    private String getParamString() {
        StringBuffer sb = new StringBuffer();
        if (this.values.length > 0) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                byte[] val = (byte[])this.values[i];
                try {
                    String sval = new String(val, "UTF8");
                    if (sval.length() == 0 && val.length > 0) {
                        sb.append("<binary value, length:");
                        sb.append(val.length);
                        sb.append(">");
                        continue;
                    }
                    sb.append(sval);
                    continue;
                }
                catch (Exception e) {
                    if (val != null) {
                        sb.append("<binary value, length:");
                        sb.append(val.length);
                        sb.append(">");
                        continue;
                    }
                    sb.append("null value");
                }
            }
        }
        return "{type='" + this.getName() + "', values='" + sb.toString() + "'}";
    }

    public String toString() {
        return "LDAPAttribute " + this.getParamString();
    }
}

