/*
 * Decompiled with CFR 0.152.
 */
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.controls.LDAPProxiedAuthControl;
import netscape.ldap.util.GetOpt;

class LDAPTool {
    protected static int m_ldapport = 389;
    protected static String m_binddn = null;
    protected static String m_ldaphost = "localhost";
    protected static String m_passwd = null;
    protected static int m_version = 3;
    protected static int m_debugLevel = 0;
    protected static int m_hopLimit = 10;
    protected static boolean m_referrals = true;
    protected static LDAPConnection m_client = null;
    protected static boolean m_justShow = false;
    protected static boolean m_verbose = false;
    protected static boolean m_ordinary = false;
    protected static LDAPControl m_proxyControl = null;

    LDAPTool() {
    }

    protected static GetOpt extractParameters(String privateOpts, String[] args) {
        GetOpt options = new GetOpt("vnRMD:h:O:p:w:d:V:y:" + privateOpts, args);
        if (options.hasOption('n')) {
            m_justShow = true;
        }
        if (options.hasOption('v')) {
            m_verbose = true;
        }
        if (options.hasOption('R')) {
            m_referrals = false;
        }
        if (options.hasOption('D')) {
            m_binddn = options.getOptionParam('D');
        }
        if (options.hasOption('h')) {
            m_ldaphost = options.getOptionParam('h');
        }
        if (options.hasOption('p')) {
            try {
                m_ldapport = Integer.parseInt(options.getOptionParam('p'));
            }
            catch (NumberFormatException e) {
                m_ldapport = 389;
            }
        }
        if (options.hasOption('O')) {
            try {
                m_hopLimit = Integer.parseInt(options.getOptionParam('O'));
            }
            catch (NumberFormatException e) {
                m_hopLimit = 10;
            }
        }
        if (options.hasOption('d')) {
            try {
                m_debugLevel = Integer.parseInt(options.getOptionParam('d'));
            }
            catch (NumberFormatException e) {
                m_debugLevel = 0;
            }
        }
        if (options.hasOption('V')) {
            try {
                m_version = Integer.parseInt(options.getOptionParam('V'));
            }
            catch (NumberFormatException e) {
                m_version = 3;
            }
        }
        if (options.hasOption('w')) {
            m_passwd = options.getOptionParam('w');
        }
        if (options.hasOption('y')) {
            m_proxyControl = new LDAPProxiedAuthControl(options.getOptionParam('y'), true);
        }
        if (options.hasOption('M')) {
            m_ordinary = true;
        }
        return options;
    }

    protected static void setDefaultReferralCredentials(LDAPConstraints cons) {
        LDAPRebind rebind = new LDAPRebind(){

            public LDAPRebindAuth getRebindAuthentication(String host, int port) {
                return new LDAPRebindAuth(m_client.getAuthenticationDN(), m_client.getAuthenticationPassword());
            }
        };
        cons.setReferrals(true);
        cons.setRebindProc(rebind);
    }
}

