/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class CircularIterator<T>
implements Iterator<T> {
    private final Iterable<T> iterable;
    private Iterator<T> iterator;
    private T nextValue;

    public CircularIterator(Collection<T> col) {
        this.iterable = Objects.requireNonNull(col);
        this.iterator = col.iterator();
        if (col.isEmpty()) {
            throw new IllegalArgumentException("CircularIterator can only be used on non-empty lists");
        }
        this.nextValue = this.advance();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public T next() {
        T next = this.nextValue;
        this.nextValue = this.advance();
        return next;
    }

    private T advance() {
        if (!this.iterator.hasNext()) {
            this.iterator = this.iterable.iterator();
        }
        return this.iterator.next();
    }

    public T peek() {
        return this.nextValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

