/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import kafkashaded.org.apache.kafka.common.config.ConfigResource;
import kafkashaded.org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import kafkashaded.org.apache.kafka.common.protocol.ApiKeys;
import kafkashaded.org.apache.kafka.common.protocol.Errors;
import kafkashaded.org.apache.kafka.common.protocol.types.Struct;
import kafkashaded.org.apache.kafka.common.requests.AbstractResponse;
import kafkashaded.org.apache.kafka.common.requests.ApiError;

public class IncrementalAlterConfigsResponse
extends AbstractResponse {
    private final IncrementalAlterConfigsResponseData data;

    public static IncrementalAlterConfigsResponseData toResponseData(int requestThrottleMs, Map<ConfigResource, ApiError> results) {
        IncrementalAlterConfigsResponseData responseData = new IncrementalAlterConfigsResponseData();
        responseData.setThrottleTimeMs(requestThrottleMs);
        for (Map.Entry<ConfigResource, ApiError> entry : results.entrySet()) {
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName(entry.getKey().name()).setResourceType(entry.getKey().type().id()).setErrorCode(entry.getValue().error().code()).setErrorMessage(entry.getValue().message()));
        }
        return responseData;
    }

    public static Map<ConfigResource, ApiError> fromResponseData(IncrementalAlterConfigsResponseData data) {
        HashMap<ConfigResource, ApiError> map = new HashMap<ConfigResource, ApiError>();
        for (IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse response : data.responses()) {
            map.put(new ConfigResource(ConfigResource.Type.forId(response.resourceType()), response.resourceName()), new ApiError(Errors.forCode(response.errorCode()), response.errorMessage()));
        }
        return map;
    }

    public IncrementalAlterConfigsResponse(IncrementalAlterConfigsResponseData data) {
        this.data = data;
    }

    public IncrementalAlterConfigsResponse(Struct struct, short version) {
        this.data = new IncrementalAlterConfigsResponseData(struct, version);
    }

    public IncrementalAlterConfigsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.responses().forEach(response -> this.updateErrorCounts(counts, Errors.forCode(response.errorCode())));
        return counts;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 0;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public static IncrementalAlterConfigsResponse parse(ByteBuffer buffer, short version) {
        return new IncrementalAlterConfigsResponse(ApiKeys.INCREMENTAL_ALTER_CONFIGS.responseSchema(version).read(buffer), version);
    }
}

