/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.record;

public enum RecordVersion {
    V0(0),
    V1(1),
    V2(2);

    private static final RecordVersion[] VALUES;
    public final byte value;

    private RecordVersion(int value) {
        this.value = (byte)value;
    }

    public boolean precedes(RecordVersion other) {
        return this.value < other.value;
    }

    public static RecordVersion lookup(byte value) {
        if (value < 0 || value >= VALUES.length) {
            throw new IllegalArgumentException("Unknown record version: " + value);
        }
        return VALUES[value];
    }

    public static RecordVersion current() {
        return V2;
    }

    static {
        VALUES = RecordVersion.values();
    }
}

