/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kafkashaded.org.apache.kafka.clients.admin.TopicDescription;
import kafkashaded.org.apache.kafka.common.KafkaFuture;
import kafkashaded.org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DescribeTopicsResult {
    private final Map<String, KafkaFuture<TopicDescription>> futures;

    protected DescribeTopicsResult(Map<String, KafkaFuture<TopicDescription>> futures) {
        this.futures = futures;
    }

    public Map<String, KafkaFuture<TopicDescription>> values() {
        return this.futures;
    }

    public KafkaFuture<Map<String, TopicDescription>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(v -> {
            HashMap<String, TopicDescription> descriptions = new HashMap<String, TopicDescription>(this.futures.size());
            for (Map.Entry<String, KafkaFuture<TopicDescription>> entry : this.futures.entrySet()) {
                try {
                    descriptions.put(entry.getKey(), entry.getValue().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return descriptions;
        });
    }
}

