/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassGenerator {
    public static final short GETSQL = 0;
    public static final short READ = 1;
    public static final short WRITE = 2;
    public static final String CRLF = "\n";
    public static final String TAB = "    ";
    public static final String BASE = "B";
    public static final String COLLECTION = "C";
    public static final String DISTINCT = "D";
    public static final String NAMEDROW = "R";
    public static final String BUILTIN = " ";
    public static final short IFX_TYPE_CHAR = 0;
    public static final short IFX_TYPE_SMALLINT = 1;
    public static final short IFX_TYPE_INT = 2;
    public static final short IFX_TYPE_FLOAT = 3;
    public static final short IFX_TYPE_SMFLOAT = 4;
    public static final short IFX_TYPE_DECIMAL = 5;
    public static final short IFX_TYPE_DATE = 7;
    public static final short IFX_TYPE_MONEY = 8;
    public static final short IFX_TYPE_NULL = 9;
    public static final short IFX_TYPE_DATETIME = 10;
    public static final short IFX_TYPE_BYTE = 11;
    public static final short IFX_TYPE_VARCHAR = 13;
    public static final short IFX_TYPE_INTERVAL = 14;
    public static final short IFX_TYPE_NCHAR = 15;
    public static final short IFX_TYPE_NVCHAR = 16;
    public static final short IFX_TYPE_INT8 = 17;
    public static final short IFX_TYPE_SERIAL8 = 18;
    public static final short IFX_TYPE_SET = 19;
    public static final short IFX_TYPE_MULTISET = 20;
    public static final short IFX_TYPE_LIST = 21;
    public static final short IFX_TYPE_ROW = 22;
    public static final short IFX_BIT_DISTINCT = 2048;
    public static final short IFX_XID_LVARCHAR = 1;
    public static final short IFX_XID_BOOLEAN = 5;
    public static final short IFX_XID_BLOB = 10;
    public static final short IFX_XID_CLOB = 11;
    static final byte TU_YEAR = 0;
    static final byte TU_MONTH = 2;
    static final byte TU_DAY = 4;
    static final byte TU_HOUR = 6;
    static final byte TU_MINUTE = 8;
    static final byte TU_SECOND = 10;
    static final byte TU_FRAC = 12;
    static final byte TU_F1 = 11;
    static final byte TU_F2 = 12;
    static final byte TU_F3 = 13;
    static final byte TU_F4 = 14;
    static final byte TU_F5 = 15;
    private String className;
    private String fileName;
    private RandomAccessFile file;
    private static Connection conn;
    private int exId;
    private String mode;
    private String owner;
    private int dataType;
    private String dataTypeName;
    private int numFields;
    private Vector fields = new Vector();
    private boolean importDF = false;
    private boolean importYM = false;

    public static void main(String[] stringArray) throws Exception {
        int n = stringArray.length;
        String string = null;
        String string2 = null;
        if (n != 0) {
            if (n > 1) {
                block6: for (int i = 1; i < stringArray.length; i += 2) {
                    switch (stringArray[i].charAt(1)) {
                        case 'U': 
                        case 'u': {
                            string = stringArray[i + 1];
                            continue block6;
                        }
                        case 'C': 
                        case 'c': {
                            string2 = stringArray[i + 1];
                        }
                    }
                }
            }
            if (string == null) {
                string = ClassGenerator.loadSetupFile();
            }
            if (string2 == null) {
                string2 = stringArray[0];
            }
        } else {
            throw new IllegalArgumentException("Usage : Java ClassGenerator datatype [URL]");
        }
        conn = ClassGenerator.connect(string);
        ClassGenerator classGenerator = new ClassGenerator(stringArray[0], string2);
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public ClassGenerator(String string, String string2) throws Exception {
        this.className = string2;
        this.dataTypeName = string;
        this.exId = this.getExId(this.dataTypeName);
        this.mode = this.getMode();
        if (this.exId == -1) {
            throw new IllegalArgumentException(this.className);
        }
        this.fileName = this.className + ".java";
        this.file = new RandomAccessFile(this.fileName, "rw");
        if (this.mode.equals(DISTINCT)) {
            this.fields = this.getDistinctFields(this.exId, "value");
        } else if (this.mode.equals(NAMEDROW)) {
            this.fields = this.getNamedRowFields(this.exId);
        } else {
            if (this.mode.equals(BASE)) {
                ClassGenerator.message("Opaque type not supported");
                return;
            }
            if (this.mode.equals(COLLECTION)) {
                ClassGenerator.message("Collection types not supported");
                return;
            }
        }
        this.generateCode("import java.sql.*;\n");
        this.generateCode("import java.math.*;\n");
        if (this.importDF) {
            this.generateCode("import com.informix.jdbc.IfxIntervalDF;\n");
        }
        if (this.importYM) {
            this.generateCode("import com.informix.jdbc.IfxIntervalYM;\n");
        }
        this.generateCode("public class " + this.className + " implements SQLData " + CRLF + "{ " + CRLF);
        for (int i = 0; i < this.numFields; ++i) {
            this.generateCode("    public " + ((Field)this.fields.elementAt((int)i)).datatype + BUILTIN + ((Field)this.fields.elementAt((int)i)).name + ";" + CRLF);
        }
        this.generateCode(0);
        this.generateCode(1);
        this.generateCode(2);
        this.generateCode("\n}\n");
        this.file.close();
        ClassGenerator.message(this.fileName + " is generated");
    }

    private static void message(String string) {
        System.out.println(string);
    }

    private static Connection connect(String string) {
        String string2 = "com.informix.jdbc.IfxDriver";
        ClassGenerator.message("URL: " + string);
        try {
            Class.forName(string2);
        }
        catch (Exception exception) {
            ClassGenerator.message("Failed to load Informix JDBC driver.");
            exception.printStackTrace();
        }
        try {
            conn = DriverManager.getConnection(string);
        }
        catch (SQLException sQLException) {
            ClassGenerator.message("Failed to connect: " + sQLException.toString());
            sQLException.printStackTrace();
        }
        return conn;
    }

    private int getExId(String string) throws SQLException {
        Statement statement = conn.createStatement();
        String string2 = "select * from informix.sysxtdtypes where name = '" + string + "'";
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            this.exId = resultSet.getInt("extended_id");
            this.mode = resultSet.getString("mode");
            this.owner = resultSet.getString("owner");
            this.dataType = resultSet.getInt("type");
        }
        return this.exId;
    }

    private void generateCode(String string) throws IOException {
        this.file.write(string.getBytes());
    }

    private void generateCode(int n) throws IOException {
        if (this.file == null) {
            throw new IOException("File Not found");
        }
        switch (n) {
            case 0: {
                String string = "    private String sql_type;\n\n    public String getSQLTypeName() { return \"" + this.dataTypeName + "\"; }" + CRLF;
                this.generateCode(string);
                break;
            }
            case 1: {
                String string = "\n    public void readSQL (SQLInput stream, String type) throws SQLException\n    {\n";
                string = string + TAB + TAB + "sql_type = type; " + CRLF;
                for (int i = 0; i < this.numFields; ++i) {
                    String string2 = "        " + ((Field)this.fields.elementAt((int)i)).name + " = " + ((Field)this.fields.elementAt((int)i)).readProcName + ";" + CRLF;
                    string = string + string2;
                }
                string = string + TAB + "}" + CRLF;
                this.generateCode(string);
                break;
            }
            case 2: {
                String string = "\n    public void writeSQL (SQLOutput stream) throws SQLException\n    { \n";
                for (int i = 0; i < this.numFields; ++i) {
                    String string3 = "        " + ((Field)this.fields.elementAt((int)i)).writeProcName + ";" + CRLF;
                    string = string + string3;
                }
                string = string + TAB + "}" + CRLF;
                this.generateCode(string);
            }
        }
    }

    public Vector getDistinctFields(int n, String string) throws SQLException {
        Statement statement = conn.createStatement();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "select * from informix.sysxtddesc where extended_id = " + n;
        ResultSet resultSet = statement.executeQuery(string5);
        while (resultSet.next()) {
            string2 = resultSet.getString(3);
        }
        string3 = ClassGenerator.getReadProcName(string2);
        string4 = ClassGenerator.getWriteProcName(string2, string);
        ++this.numFields;
        this.fields.addElement(new Field(string, string2, string3, string4));
        return this.fields;
    }

    public Vector getNamedRowFields(int n) throws SQLException {
        Statement statement = conn.createStatement();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "select * from informix.sysattrtypes where extended_id =" + n + " and fieldno > 0";
        ResultSet resultSet = statement.executeQuery(string5);
        while (resultSet.next()) {
            string = resultSet.getString("fieldname").trim();
            int n2 = resultSet.getInt("type");
            int n3 = resultSet.getInt("xtd_type_id");
            short s = (short)resultSet.getInt("length");
            if (n3 != 0) {
                String string6 = "select * from informix.sysxtdtypes where extended_id = " + n3;
                Statement statement2 = conn.createStatement();
                ResultSet resultSet2 = statement2.executeQuery(string6);
                resultSet2.next();
                if ((n2 & 0x800) > 0) {
                    n2 &= 0xFF;
                    n3 = resultSet2.getInt("source");
                }
                if (n3 == 1) {
                    string3 = "stream.readString()";
                    string4 = "stream.writeString(" + string + ")";
                    string2 = "String";
                } else if (n3 == 5) {
                    string3 = "stream.readBoolean()";
                    string4 = "stream.writeBoolean(" + string + ")";
                    string2 = "boolean";
                } else if (n3 == 10) {
                    string3 = "stream.readBlob()";
                    string4 = "stream.writeBlob(" + string + ")";
                    string2 = "Blob";
                } else if (n3 == 11) {
                    string3 = "stream.readClob()";
                    string4 = "stream.writeClob(" + string + ")";
                    string2 = "Clob";
                } else {
                    s = (short)resultSet2.getInt("length");
                    string2 = this.toJavabuiltintypes(n2, s);
                    if (string2 != null) {
                        string3 = ClassGenerator.getReadProcName(string2);
                        string4 = ClassGenerator.getWriteProcName(string2, string);
                    } else {
                        string2 = resultSet2.getString("name").trim();
                        string3 = "(" + string2 + ")" + "stream.readObject()";
                        string4 = "stream.writeObject(" + string + ")";
                    }
                }
            } else {
                string2 = this.toJavabuiltintypes(n2, s);
                if (string2 == null) {
                    throw new ClassGeneratorException("Data type not supported");
                }
                string3 = ClassGenerator.getReadProcName(string2);
                string4 = ClassGenerator.getWriteProcName(string2, string);
            }
            ++this.numFields;
            this.fields.addElement(new Field(string, string2, string3, string4));
        }
        return this.fields;
    }

    private static String getReadProcName(String string) {
        if (string.startsWith("IfxInterval")) {
            return "new " + string + "(stream.readString())";
        }
        if (string.equalsIgnoreCase("struct")) {
            return "(Struct)stream.readObject()";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        return "stream.read" + stringBuffer + "()";
    }

    private static String getWriteProcName(String string, String string2) {
        if (string.startsWith("IfxInterval")) {
            return "stream.writeString(" + string2 + ".toString())";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        return "stream.write" + stringBuffer + "(" + string2 + ")";
    }

    private String toJavabuiltintypes(int n, short s) {
        switch (n) {
            case 0: {
                return "String";
            }
            case 1: {
                return "short";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "BigDecimal";
            }
            case 7: {
                return "Date";
            }
            case 8: {
                return "BigDecimal";
            }
            case 9: {
                return "String";
            }
            case 10: {
                return this.getTimeType(s);
            }
            case 13: {
                return "String";
            }
            case 14: {
                return this.getIntervalType(s);
            }
            case 15: {
                return "String";
            }
            case 16: {
                return "String";
            }
            case 19: {
                return "Array";
            }
            case 20: {
                return "Array";
            }
            case 21: {
                return "Array";
            }
            case 17: {
                return "long";
            }
            case 22: {
                return "Struct";
            }
        }
        return null;
    }

    private String getMode() {
        return this.mode;
    }

    private String getTimeType(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        if (by < 6) {
            return "Timestamp";
        }
        return "Time";
    }

    private String getIntervalType(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        if (by < 6) {
            this.importYM = true;
            return "IfxIntervalYM";
        }
        this.importDF = true;
        return "IfxIntervalDF";
    }

    public static String loadSetupFile() throws Exception {
        StringTokenizer stringTokenizer;
        String string = null;
        Object var1_1 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = "aa";
        String string13 = null;
        String string14 = null;
        String string15 = System.getProperty("user.home", ".");
        if (string15 == null) {
            string15 = ".";
        }
        FileInputStream fileInputStream = new FileInputStream(string15 + "/setup.std");
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        while (string12 != null && (string12 = dataInputStream.readLine()) != null && (stringTokenizer = new StringTokenizer(string12, " \t")) != null && stringTokenizer.hasMoreTokens()) {
            string13 = stringTokenizer.nextToken();
            if (string13 == null) {
                return null;
            }
            if (string13.equals("URL")) {
                string14 = stringTokenizer.nextToken();
                continue;
            }
            if (string13.equals("database")) {
                string = stringTokenizer.nextToken();
                continue;
            }
            if (string13.equals("user")) {
                string2 = stringTokenizer.nextToken();
                continue;
            }
            if (string13.equals("passwd")) {
                string3 = stringTokenizer.nextToken();
                continue;
            }
            if (string13.equals("USEV5SERVER")) {
                if (!stringTokenizer.nextToken().equals("1")) continue;
                bl = true;
                continue;
            }
            if (string13.equals("informixserver")) {
                string4 = stringTokenizer.nextToken();
                continue;
            }
            if (string13.equals("informixProperties")) {
                string5 = stringTokenizer.nextToken();
                continue;
            }
            if (string13.equalsIgnoreCase("SQLH_TYPE")) {
                string10 = stringTokenizer.nextToken();
                continue;
            }
            if (string13.equalsIgnoreCase("LDAP_IFXBASE")) {
                string8 = stringTokenizer.nextToken();
                continue;
            }
            if (string13.equalsIgnoreCase("LDAP_URL")) {
                string9 = stringTokenizer.nextToken();
                continue;
            }
            if (string13.equalsIgnoreCase("LDAP_USER")) {
                string6 = stringTokenizer.nextToken();
                continue;
            }
            if (string13.equalsIgnoreCase("LDAP_PASSWD")) {
                string7 = stringTokenizer.nextToken();
                continue;
            }
            if (!string13.equalsIgnoreCase("SQLH_FILE")) continue;
            string11 = stringTokenizer.nextToken();
        }
        String string16 = ":";
        if (string != null) {
            string14 = string14 + "/" + string;
        }
        if (string14.equals("jdbc:informix-sqli:")) {
            string16 = "";
        }
        if (string2 != null) {
            string14 = string14 + string16 + "user=" + string2;
            string16 = ";";
        }
        if (string3 != null) {
            string14 = string14 + string16 + "password=" + string3;
            string16 = ";";
        }
        if (string4 != null) {
            string14 = string14 + string16 + "informixserver=" + string4;
            string16 = ";";
        } else {
            ClassGenerator.message("Informix server must be specified either in your setup.std file ");
        }
        if (bl) {
            string14 = string14 + ";USEV5SERVER=1";
        }
        if (string10 != null) {
            string14 = string14 + ";sqlh_type=" + string10;
        }
        if (string6 != null) {
            string14 = string14 + ";ldap_user=" + string6;
        }
        if (string7 != null) {
            string14 = string14 + ";ldap_passwd=" + string7;
        }
        if (string9 != null) {
            string14 = string14 + ";ldap_url=" + string9;
        }
        if (string8 != null) {
            string14 = string14 + ";ldap_ifxbase=" + string8;
        }
        if (string11 != null) {
            string14 = string14 + ";sqlh_file=" + string11;
        }
        return string14;
    }
}

