/*
 * Decompiled with CFR 0.152.
 */
package sqlj.tools;

import java.io.FileInputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import sqlj.util.io.StringWriter;

public class SourceMapper
extends FilterWriter {
    private Reader m_isr = null;
    private StringWriter m_sw = null;
    private static final int SRC = 0;
    private static final int TGT = 1;
    private int size = 0;
    private int MAX_SIZE = 20;
    private int[][] sline = new int[2][this.MAX_SIZE];
    private int[][] scol = new int[2][this.MAX_SIZE];
    private int[][] eline = new int[2][this.MAX_SIZE];
    private int[][] ecol = new int[2][this.MAX_SIZE];
    private boolean ready = false;
    private boolean CR_SEEN = false;
    private int line_count = 1;
    private int col_count = 0;
    private int prev_col_count = 0;
    private static final int OTHER = 1;
    private static final int USER_CODE = 2;
    private static final int GENERATED_CODE = 3;
    private static final int LINEINFO = 4;
    private int startTokenColumn = 0;
    private int startTokenLine = 0;
    private int startTokenColOnPrevLine = 0;
    private int endTokenColumn = 0;
    private int endTokenLine = 0;
    private int info_line = 0;
    private int info_column = 0;
    private int line_at_info = 0;
    private int column_at_info = 0;
    static String USER_CODE_TAG = "user-code";
    static String GENERATED_CODE_TAG = "generated-code";
    private static String AT_LINEINFO_TAG = "@lineinfo:";
    private Integer m_sline = null;
    private Integer m_scol = null;
    private Integer m_eline = null;
    private Integer m_ecol = null;
    private int line_start;
    private int col_start;
    private int line_end;
    private int col_end;

    public SourceMapper(String string) {
        super(new StringWriter());
        this.size = 0;
        try {
            this.m_sw = null;
            FileInputStream fileInputStream = new FileInputStream(string);
            this.m_isr = new InputStreamReader(fileInputStream);
            this.readAll();
            this.m_isr.close();
            fileInputStream.close();
            this.ready = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SourceMapper(Reader reader) {
        super(new StringWriter());
        try {
            this.m_sw = null;
            this.m_isr = reader;
            this.readAll();
            this.m_isr.close();
            this.ready = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int size() {
        if (!this.ready) {
            throw new IllegalArgumentException("SourceMapper: request for mapping with map construction pending");
        }
        return this.size;
    }

    public SourceMapper(Writer writer) {
        super(writer);
        this.m_isr = null;
        this.m_sw = new StringWriter();
    }

    private void allocate() {
        int n = this.MAX_SIZE * 2;
        int[][] nArray = new int[2][n];
        int[][] nArray2 = new int[2][n];
        int[][] nArray3 = new int[2][n];
        int[][] nArray4 = new int[2][n];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.MAX_SIZE; ++j) {
                nArray[i][j] = this.sline[i][j];
                nArray2[i][j] = this.scol[i][j];
                nArray3[i][j] = this.eline[i][j];
                nArray4[i][j] = this.ecol[i][j];
            }
        }
        this.sline = nArray;
        this.scol = nArray2;
        this.eline = nArray3;
        this.ecol = nArray4;
        this.MAX_SIZE = n;
    }

    private void readAll() {
        try {
            int n = 1;
            int n2 = 1;
            int n3 = 1;
            int n4 = 1;
            int n5 = 1;
            while (true) {
                if (n != 3) {
                    n = this.readToken();
                    continue;
                }
                if (this.readToken() == 4) {
                    n2 = this.info_line;
                    n3 = this.info_column;
                    n4 = this.endTokenLine;
                    n5 = this.endTokenColumn;
                }
                while (n != 2) {
                    n = this.readToken();
                }
                this.readToken();
                if (this.size == this.MAX_SIZE) {
                    this.allocate();
                }
                this.sline[1][this.size] = n4;
                this.scol[1][this.size] = n5;
                this.eline[1][this.size] = this.line_count;
                this.ecol[1][this.size] = this.col_count;
                this.sline[0][this.size] = n2;
                this.scol[0][this.size] = n3;
                this.eline[0][this.size] = this.info_line;
                this.ecol[0][this.size] = this.info_column - 1;
                ++this.size;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private char nextChar() throws IOException {
        int n = this.m_isr.read();
        if (n < 0) {
            throw new IOException("EOF");
        }
        char c = (char)n;
        ++this.col_count;
        if (c == '\r') {
            this.CR_SEEN = true;
            ++this.line_count;
            this.prev_col_count = this.col_count;
            this.col_count = 0;
        } else if (c == '\n') {
            if (!this.CR_SEEN) {
                this.prev_col_count = this.col_count;
                ++this.line_count;
            } else {
                this.CR_SEEN = false;
            }
            this.col_count = 0;
        } else {
            this.CR_SEEN = false;
        }
        return c;
    }

    private int readToken() throws IOException {
        char c;
        this.startTokenLine = this.line_count;
        this.startTokenColumn = this.col_count;
        if (this.startTokenColumn == 1) {
            this.startTokenColOnPrevLine = this.prev_col_count + 1;
        }
        if ((c = this.nextChar()) == '\"') {
            this.readEnclosing(34);
            return this.setOtherTokenEnd();
        }
        if (c == '\'') {
            this.readEnclosing(39);
            return this.setOtherTokenEnd();
        }
        if (c == '/') {
            c = this.nextChar();
            if (c == '/') {
                c = this.nextChar();
                while (c != '\n' && c != '\r') {
                    c = this.nextChar();
                }
                return this.setOtherTokenEnd();
            }
            if (c == '*') {
                c = this.nextChar();
                if (c == '@' && this.readAtLineinfo(c)) {
                    c = this.nextChar();
                    if ('0' <= c && c <= '9') {
                        if (this.readLineInfo(c)) {
                            this.line_at_info = this.line_count;
                            this.column_at_info = this.col_count;
                            return 4;
                        }
                        return this.setOtherTokenEnd();
                    }
                    if (c == 'u') {
                        if (this.readUserCode(c)) {
                            return 2;
                        }
                        return this.setOtherTokenEnd();
                    }
                    if (c == 'g') {
                        if (this.readGeneratedCode(c)) {
                            return 3;
                        }
                        return this.setOtherTokenEnd();
                    }
                    this.readComment(c);
                    return this.setOtherTokenEnd();
                }
                this.readComment(c);
                return this.setOtherTokenEnd();
            }
        } else if (c == '\\') {
            c = this.nextChar();
            if (c == 'u') {
                this.readUnicode();
            }
            return this.setOtherTokenEnd();
        }
        return this.setOtherTokenEnd();
    }

    private int setOtherTokenEnd() {
        this.endTokenLine = this.line_count;
        this.endTokenColumn = this.col_count;
        return 1;
    }

    private boolean readLineInfo(char c) throws IOException {
        this.info_line = 0;
        this.info_column = 0;
        while ('0' <= c && c <= '9') {
            this.info_line *= 10;
            this.info_line += c - 48;
            c = this.nextChar();
        }
        if (c != '^') {
            this.readComment(c);
            return false;
        }
        c = this.nextChar();
        if (c < '0' || '9' < c) {
            this.readComment(c);
            return false;
        }
        while ('0' <= c && c <= '9') {
            this.info_column *= 10;
            this.info_column += c - 48;
            c = this.nextChar();
        }
        return this.readEndComment(c);
    }

    private boolean readUserCode(char c) throws IOException {
        for (int i = 0; i < USER_CODE_TAG.length(); ++i) {
            if (USER_CODE_TAG.charAt(i) != c) {
                this.readComment(c);
                return false;
            }
            c = this.nextChar();
        }
        return this.readEndComment(c);
    }

    private boolean readGeneratedCode(char c) throws IOException {
        for (int i = 0; i < GENERATED_CODE_TAG.length(); ++i) {
            if (GENERATED_CODE_TAG.charAt(i) != c) {
                this.readComment(c);
                return false;
            }
            c = this.nextChar();
        }
        return this.readEndComment(c);
    }

    private boolean readAtLineinfo(char c) throws IOException {
        for (int i = 0; i < AT_LINEINFO_TAG.length(); ++i) {
            if (AT_LINEINFO_TAG.charAt(i) != c) {
                this.readComment(c);
                return false;
            }
            if (i >= AT_LINEINFO_TAG.length() - 1) continue;
            c = this.nextChar();
        }
        return true;
    }

    private void readEnclosing(int n) throws IOException {
        boolean bl = false;
        char c = this.nextChar();
        while (true) {
            if (bl && c == 'u') {
                this.readUnicode();
                bl = false;
            } else if (bl) {
                bl = false;
            } else if (c == n) {
                return;
            }
            c = this.nextChar();
        }
    }

    private void readUnicode() throws IOException {
        this.nextChar();
        this.nextChar();
        this.nextChar();
        this.nextChar();
    }

    private void readComment(char c) throws IOException {
        boolean bl = c == '*';
        c = this.nextChar();
        while (!bl || c != '/') {
            bl = c == '*';
            c = this.nextChar();
        }
        return;
    }

    private boolean readEndComment(char c) throws IOException {
        if (c == '*' && (c = this.nextChar()) == '/') {
            return true;
        }
        this.readComment(c);
        return false;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.ready) {
            throw new IOException("write not permitted on this SourceMapper");
        }
        this.m_sw.write(cArray, n, n2);
        super.write(cArray, n, n2);
    }

    public void write(int n) throws IOException {
        if (this.ready) {
            throw new IOException("write not permitted on this SourceMapper");
        }
        this.m_sw.write(n);
        super.write(n);
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this.ready) {
            throw new IOException("write not permitted on this SourceMapper");
        }
        this.m_sw.write(string, n, n2);
        super.write(string, n, n2);
    }

    public void flush() throws IOException {
        if (this.ready) {
            throw new IOException("flush not permitted on this SourceMapper");
        }
        this.m_sw.flush();
        super.flush();
    }

    public void close() throws IOException {
        if (this.ready) {
            throw new IOException("close not permitted on this SourceMapper");
        }
        this.m_sw.close();
        this.m_isr = new StringReader(this.m_sw.toString());
        this.readAll();
        this.m_isr.close();
        this.ready = true;
        this.m_sw = null;
        this.m_isr = null;
    }

    public int startLine() {
        if (this.m_sline != null) {
            return this.m_sline;
        }
        throw new IllegalArgumentException("startLine(): no line/col info available");
    }

    public int startCol() {
        if (this.m_scol != null) {
            return this.m_scol;
        }
        throw new IllegalArgumentException("startCol(): no line/col info available");
    }

    public int endLine() {
        if (this.m_eline != null) {
            return this.m_eline;
        }
        throw new IllegalArgumentException("endLine(): no line/col info available");
    }

    public int endCol() {
        if (this.m_ecol != null) {
            return this.m_ecol;
        }
        throw new IllegalArgumentException("endCol(): no line/col info available");
    }

    public void srcLineToTgt(int n, int n2) {
        this.lineRange(0, n, n2, n, n2, 1);
    }

    public void srcLineToTgt(int n, int n2, int n3, int n4) {
        this.lineRange(0, n, n2, n3, n4, 1);
    }

    public void tgtLineToSrc(int n, int n2) {
        this.lineRange(1, n, n2, n, n2, 0);
    }

    public void tgtLineToSrc(int n, int n2, int n3, int n4) {
        this.lineRange(1, n, n2, n3, n4, 0);
    }

    private void lineRange(int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.ready) {
            throw new IllegalArgumentException("SourceMapper: request for mapping with map construction pending");
        }
        if (n4 < n2 || n2 == n4 && n5 < n3) {
            throw new IllegalArgumentException("end line/col < start line/col");
        }
        this.lookupLineCol(n, n2, n3, n6);
        if (n2 == n4 && n3 == n5) {
            this.m_sline = new Integer(this.line_start);
            this.m_scol = new Integer(this.col_start);
            this.m_eline = new Integer(this.line_end);
            this.m_ecol = new Integer(this.col_end);
            return;
        }
        int n7 = this.line_start;
        int n8 = this.col_start;
        int n9 = this.line_end;
        int n10 = this.col_end;
        this.lookupLineCol(n, n4, n5, n6);
        this.m_sline = new Integer(n7);
        this.m_scol = new Integer(n8);
        if (n9 > this.line_end || n9 == this.line_end && n10 > this.col_end) {
            this.m_eline = new Integer(n9);
            this.m_ecol = new Integer(n10);
        } else {
            this.m_eline = new Integer(this.line_end);
            this.m_ecol = new Integer(this.col_end);
        }
    }

    private void lookupLineCol(int n, int n2, int n3, int n4) {
        if (this.size == 0 || n2 < this.sline[n][0] || n2 == this.sline[n][0] && n3 < this.scol[n][0]) {
            this.line_end = this.line_start = n2;
            this.col_end = this.col_start = n3;
            return;
        }
        if (n2 > this.eline[n][this.size - 1]) {
            this.line_start = n2 - this.eline[n][this.size - 1] + this.eline[n4][this.size - 1];
            this.col_start = n3;
            this.line_end = this.line_start;
            this.col_end = this.col_start;
            return;
        }
        if (n2 == this.eline[n][this.size - 1] && n3 > this.ecol[n][this.size - 1]) {
            this.line_start = this.eline[n4][this.size - 1];
            this.col_start = n3 - this.ecol[n][this.size - 1] + this.ecol[n4][this.size - 1];
            this.line_end = this.line_start;
            this.col_end = this.col_start;
            return;
        }
        int n5 = this.searchLineCol(n, n2, n3);
        if (n5 < 0 || n5 >= this.size) {
            throw new IllegalArgumentException("Internal error: line/col not found:" + n2 + "/" + n3);
        }
        if (n2 < this.eline[n][n5] || n2 == this.eline[n][n5] && n3 <= this.ecol[n][n5]) {
            this.line_start = this.sline[n4][n5];
            this.col_start = this.scol[n4][n5];
            this.line_end = this.eline[n4][n5];
            this.col_end = this.ecol[n4][n5];
            return;
        }
        if (this.eline[n][n5] < n2) {
            this.line_end = this.line_start = n2 - this.eline[n][n5] + this.eline[n4][n5];
            this.col_end = this.col_start = n3;
            return;
        }
        this.line_end = this.line_start = this.eline[n4][n5];
        this.col_end = this.col_start = n3 - this.ecol[n][n5] + this.ecol[n4][n5];
    }

    private int searchLineCol(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.size - 1;
        while (true) {
            if (n4 > n5) {
                if (this.size > 0 && (this.eline[n][this.size - 1] < n2 || this.eline[n][this.size - 1] == n2 && this.ecol[n][this.size - 1] < n3)) {
                    return this.size;
                }
                return -1;
            }
            int n6 = (n4 + n5) / 2;
            int n7 = this.sline[n][n6];
            int n8 = this.scol[n][n6];
            if ((n7 < n2 || n7 == n2 && n8 <= n3) && (n6 == this.size - 1 || n2 < this.sline[n][n6 + 1] || n2 == this.sline[n][n6 + 1] && n3 < this.scol[n][n6 + 1])) {
                return n6;
            }
            if (n7 > n2 || n7 == n2 && n8 > n3) {
                n5 = n6 - 1;
                continue;
            }
            n4 = n6 + 1;
        }
    }
}

