/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sqlj.codegen.ParseletFactory;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.JSError;
import sqlj.framework.ide.TranslationOptionsQuery;
import sqlj.framework.options.ConnectionFactory;
import sqlj.framework.options.HasOptions;
import sqlj.framework.options.InvalidOptionException;
import sqlj.framework.options.OptionGroup;
import sqlj.framework.options.OptionInfoArray;
import sqlj.framework.options.PropertyList;
import sqlj.framework.options.PropertyListImpl;
import sqlj.mesg.SemanticErrors;
import sqlj.mesg.SemanticOptions;
import sqlj.mesg.TranslatorErrors;
import sqlj.semantics.AnalysisCache;
import sqlj.semantics.ConnectionManager;
import sqlj.semantics.ContextAnalysis;
import sqlj.semantics.CursorAnalysis;
import sqlj.semantics.ExecAnalysis;
import sqlj.semantics.SemanticAnalyzer;
import sqlj.semantics.TypeProperties;
import sqlj.syntax.ClassElem;
import sqlj.syntax.ContextElem;
import sqlj.syntax.CursorElem;
import sqlj.syntax.Elem;
import sqlj.syntax.ExecElem;
import sqlj.util.Disposable;
import sqlj.util.TranslationContext;

public class SemanticAnalyzerFactory
implements HasOptions {
    private static final int invalid_mode = -999;
    private static Hashtable interestingOptions = null;
    private ConnectionFactory m_connFact = new ConnectionFactory();
    private TranslationOptionsQuery m_qp = null;
    private Hashtable m_url = new Hashtable();
    private SemanticAnalyzerFactory m_myself = null;
    protected Hashtable cachedAnalyses = null;
    private String[] checker_tags = new String[]{"warn", "online", "offline", "driver", "cache", "default-url-prefix"};
    private String[] context_tags = new String[]{"user", "password", "url"};
    private boolean[] checker_taggability = new boolean[]{false, true, false, false, false, false};
    private boolean[] context_taggability = new boolean[]{true, true, true};
    protected Boolean TRUE = new Boolean(true);
    TranslationContext m_tc = null;
    TypeProperties m_tp = new TypeProperties();
    ConnectionManager m_cm = null;
    ParseletFactory m_pf = null;
    private ErrorLog m_options_error_log;
    private boolean m_warn_done = false;
    private boolean m_verbose;
    private boolean m_nulls;
    private boolean m_precision;
    private boolean m_portable;
    private boolean m_strict;
    private Boolean m_cache = null;
    private String m_url_prefix = null;
    private OptionGroup m_og;
    private HasOptions m_checker_options;
    private HasOptions m_context_options;
    Hashtable m_all_options = new Hashtable();
    Hashtable m_all_infos = new Hashtable();
    Hashtable m_taggable_options = new Hashtable();
    private int start_cache_size = 0;

    public static void captureInterestingOptions() {
        interestingOptions = new Hashtable();
    }

    public static Hashtable getInterestingOptions() {
        Hashtable hashtable = interestingOptions;
        interestingOptions = null;
        return hashtable;
    }

    public SemanticAnalyzerFactory(TranslationContext translationContext, ParseletFactory parseletFactory) {
        this(parseletFactory);
        this.m_tc = translationContext;
        if (this.m_tc != null) {
            this.registerOptionsQuery(this.m_tc.getOptionsQuery());
        }
    }

    public SemanticAnalyzerFactory(ParseletFactory parseletFactory) {
        this.m_pf = parseletFactory;
        this.m_cm = new ConnectionManager(this);
        this.initializeOptions();
        this.m_myself = this;
    }

    public SemanticAnalyzer newSemanticAnalyzer(Elem elem) {
        throw new IllegalArgumentException("SemanticAnalyzerFactory.newSemanticAnalyzer(Elem) - illegal argument type");
    }

    public SemanticAnalyzer newSemanticAnalyzer(ClassElem classElem) {
        throw new IllegalArgumentException("SemanticAnalyzerFactory.newSemanticAnalyzer(ClassElem) - illegal argument type");
    }

    public SemanticAnalyzer newSemanticAnalyzer(ExecElem execElem) {
        return new ExecAnalysis(execElem, this);
    }

    public SemanticAnalyzer newSemanticAnalyzer(CursorElem cursorElem) {
        return new CursorAnalysis(cursorElem, this);
    }

    public SemanticAnalyzer newSemanticAnalyzer(ContextElem contextElem) {
        return new ContextAnalysis(contextElem, this);
    }

    public void registerOptionsQuery(TranslationOptionsQuery translationOptionsQuery) {
        this.m_cm.registerOptionsQuery(translationOptionsQuery);
        this.m_qp = translationOptionsQuery;
    }

    public Enumeration getOnline() {
        return this.getOnline(null);
    }

    public Enumeration getOnline(String string) {
        String string2 = this.getOption(string, "online");
        if (string2 == null && string != null) {
            string2 = this.getOption(null, "online");
        }
        if (string2 == null) {
            string2 = "";
        }
        return this.enumerate(string2);
    }

    public String getOffline() {
        return this.getOffline(null);
    }

    public String getOffline(String string) {
        String string2 = this.getOption(string, "offline");
        if (string2 == null && string != null) {
            string2 = this.getOption(null, "offline");
        }
        if (string2 == null) {
            string2 = "Please specify an offline SQL checker!";
        }
        return string2;
    }

    public boolean getVerbose() {
        if (!this.m_warn_done) {
            this.processWarn();
        }
        return this.m_verbose;
    }

    public boolean getNulls() {
        if (!this.m_warn_done) {
            this.processWarn();
        }
        return this.m_nulls;
    }

    public boolean getPrecision() {
        if (!this.m_warn_done) {
            this.processWarn();
        }
        return this.m_precision;
    }

    public boolean getPortable() {
        if (!this.m_warn_done) {
            this.processWarn();
        }
        return this.m_portable;
    }

    public boolean getStrict() {
        if (!this.m_warn_done) {
            this.processWarn();
        }
        return this.m_strict;
    }

    private void processWarn() {
        Enumeration enumeration = this.enumerate(this.getOption("warn"));
        while (enumeration.hasMoreElements()) {
            String string = ((String)enumeration.nextElement()).toLowerCase();
            if (string.equals("none")) {
                this.m_verbose = false;
                this.m_nulls = false;
                this.m_precision = false;
                this.m_portable = false;
                this.m_strict = false;
                continue;
            }
            if (string.equals("all")) {
                this.m_verbose = true;
                this.m_nulls = true;
                this.m_precision = true;
                this.m_portable = true;
                this.m_strict = true;
                continue;
            }
            if (string.equals("verbose")) {
                this.m_verbose = true;
                continue;
            }
            if (string.equals("noverbose")) {
                this.m_verbose = false;
                continue;
            }
            if (string.equals("nulls")) {
                this.m_nulls = true;
                continue;
            }
            if (string.equals("nonulls")) {
                this.m_nulls = false;
                continue;
            }
            if (string.equals("precision")) {
                this.m_precision = true;
                continue;
            }
            if (string.equals("noprecision")) {
                this.m_precision = false;
                continue;
            }
            if (string.equals("portable")) {
                this.m_portable = true;
                continue;
            }
            if (string.equals("noportable")) {
                this.m_portable = false;
                continue;
            }
            if (string.equals("strict")) {
                this.m_strict = true;
                continue;
            }
            if (string.equals("nostrict")) {
                this.m_strict = false;
                continue;
            }
            this.m_options_error_log.addEntry(new JSError(SemanticErrors.invalidWarnOption(string)));
        }
        this.m_warn_done = true;
    }

    public int getDefaultFunctionMode() {
        return 1;
    }

    public int getDefaultProcedureMode() {
        return 1;
    }

    public int getDefaultBlockMode() {
        return 1;
    }

    protected boolean getCacheing() {
        if (this.m_cache == null) {
            this.m_cache = new Boolean(this.getBooleanOption("cache"));
        }
        return this.m_cache;
    }

    public Enumeration getDrivers() {
        return this.enumerate(this.getOption("driver"));
    }

    protected String getUrlPrefix() {
        if (this.m_url_prefix == null) {
            this.m_url_prefix = this.getOption("default-url-prefix");
        }
        return this.m_url_prefix;
    }

    public String getUser() {
        return this.getUser(null);
    }

    public String getUser(String string) {
        return this.getOption(string, "user");
    }

    public String getPassword() {
        return this.getPassword(null);
    }

    public String getPassword(String string) {
        return this.getOption(string, "password");
    }

    public String getURL() {
        return this.getURL(null);
    }

    public String getURL(String string) {
        String string2 = this.getOption(string, "url");
        if (string2 != null) {
            return string2;
        }
        if (string == null) {
            string = "";
        }
        if ((string2 = (String)this.m_url.get(string)) != null) {
            return string2;
        }
        if (this.m_qp != null && (string2 = this.m_qp.getURL(string)) != null) {
            this.m_url.put(string, string2);
        }
        return string2;
    }

    private void initializeOptions() {
        int n;
        Integer n2 = new Integer(0);
        String[][] stringArray = new String[this.checker_tags.length + this.context_tags.length][];
        boolean[] blArray = new boolean[this.checker_tags.length + this.context_tags.length];
        for (n = 0; n < this.checker_tags.length; ++n) {
            stringArray[n] = SemanticOptions.getOptionInfo(this.checker_tags[n]);
            blArray[n] = this.checker_taggability[n];
        }
        for (n = 0; n < this.context_tags.length; ++n) {
            stringArray[n + this.checker_tags.length] = SemanticOptions.getOptionInfo(this.context_tags[n]);
            blArray[n + this.checker_tags.length] = this.context_taggability[n];
        }
        this.m_og = new OptionGroup();
        this.m_og.addElement(new TaggedOptions(stringArray, blArray));
    }

    public void setOptions(PropertyList propertyList, ErrorLog errorLog) throws InvalidOptionException {
        this.m_options_error_log = errorLog;
        this.m_og.setOptions(propertyList, errorLog);
        if (interestingOptions != null) {
            Enumeration enumeration = propertyList.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("driver") && !string.startsWith("default-url-prefix")) continue;
                interestingOptions.put(string, propertyList.getProperty(string));
            }
        }
    }

    public String[][] getOptionInfo() {
        return this.m_og.getOptionInfo();
    }

    private String getOption(String string, String string2) {
        String string3;
        PropertyList propertyList;
        if (string == null) {
            string = "";
        }
        if ((propertyList = (PropertyList)this.m_all_options.get(string2)) == null) {
            string3 = null;
        } else {
            string3 = propertyList.getProperty(string);
            if (string3 != null) {
                string3 = string3.trim();
            }
        }
        return string3;
    }

    private String getOption(String string) {
        return this.getOption(null, string);
    }

    private boolean getBooleanOption(String string) {
        String string2 = this.getOption(string);
        if (string2 == null) {
            string2 = "";
        }
        if ((string2 = string2.toLowerCase().trim()).equals("1") || string2.equals("y") || string2.equals("yes") || string2.equals("t") || string2.equals("true") || string2.equals("on") || string2.equals("+")) {
            return true;
        }
        if (string2.equals("0") || string2.equals("n") || string2.equals("no") || string2.equals("f") || string2.equals("false") || string2.equals("off") || string2.equals("-")) {
            return false;
        }
        this.m_options_error_log.addEntry(new JSError(SemanticErrors.illegalBooleanOptionEntry(string, string2)));
        return false;
    }

    private Enumeration enumerate(String string) {
        return new StringTokenizer(string, " \t,");
    }

    public void readCache() {
        Object object;
        Object object2;
        this.start_cache_size = 0;
        this.cachedAnalyses = new Hashtable();
        if (this.m_tc != null) {
            object2 = this.m_tc.getDisposer();
            object = new Cleanup();
            ((Disposable.Disposer)object2).register((Disposable)object);
        }
        object2 = null;
        object = null;
        int n = 0;
        int n2 = 0;
        try {
            object2 = new FileInputStream("SQLChecker.cache");
            object = new ObjectInputStream((InputStream)object2);
            int n3 = (Integer)((ObjectInputStream)object).readObject();
            if (n3 == AnalysisCache.version) {
                n2 = (Integer)((ObjectInputStream)object).readObject();
                for (int i = 0; i < n2; ++i) {
                    String string = (String)((ObjectInputStream)object).readObject();
                    AnalysisCache analysisCache = new AnalysisCache((ObjectInput)object, this);
                    this.cachedAnalyses.put(string, analysisCache);
                    ++n;
                }
            }
            if (object != null) {
                ((ObjectInputStream)object).close();
            }
            if (object2 != null) {
                ((FileInputStream)object2).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getVerbose()) {
            this.m_options_error_log.addEntry(new Info(SemanticErrors.writeCheckingInfo(n, n2)));
        }
        this.start_cache_size = n;
    }

    public void writeCache() {
        if (this.cachedAnalyses == null) {
            return;
        }
        if (this.cachedAnalyses.size() == this.start_cache_size) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        int n = 0;
        try {
            fileOutputStream = new FileOutputStream("SQLChecker.cache");
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(AnalysisCache.version);
            objectOutputStream.writeObject(new Integer(this.cachedAnalyses.size()));
            Enumeration enumeration = this.cachedAnalyses.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                AnalysisCache analysisCache = (AnalysisCache)this.cachedAnalyses.get(string);
                objectOutputStream.writeObject(string);
                analysisCache.writeObject(objectOutputStream);
                ++n;
            }
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Cleanup
    implements Disposable {
        Cleanup() {
        }

        public void dispose() {
            SemanticAnalyzerFactory.this.writeCache();
            SemanticAnalyzerFactory.this.m_cm = new ConnectionManager(SemanticAnalyzerFactory.this.m_myself);
            SemanticAnalyzerFactory.this.m_cm.registerOptionsQuery(SemanticAnalyzerFactory.this.m_qp);
        }
    }

    class TaggedOptions
    implements HasOptions {
        public TaggedOptions(String[][] stringArray, boolean[] blArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                PropertyListImpl propertyListImpl = new PropertyListImpl();
                SemanticAnalyzerFactory.this.m_all_options.put(stringArray[i][0], propertyListImpl);
                SemanticAnalyzerFactory.this.m_all_infos.put(stringArray[i][0], stringArray[i]);
                if (blArray[i]) {
                    SemanticAnalyzerFactory.this.m_taggable_options.put(stringArray[i][0], SemanticAnalyzerFactory.this.TRUE);
                }
                if (stringArray[i][2] == null) continue;
                propertyListImpl.addProperty("", stringArray[i][2], stringArray[i][4]);
            }
        }

        public void setOptions(PropertyList propertyList, ErrorLog errorLog) throws InvalidOptionException {
            int n = 0;
            Enumeration enumeration = propertyList.propertyNames(false);
            while (enumeration.hasMoreElements()) {
                PropertyListImpl propertyListImpl;
                String string;
                String string2 = (String)enumeration.nextElement();
                String string3 = string = string2.trim();
                String string4 = null;
                int n2 = string3.indexOf("@");
                if (n2 >= 0) {
                    string3 = string.substring(0, n2).trim();
                    string4 = string.substring(n2 + 1).trim();
                }
                if (string4 == null) {
                    string4 = "";
                }
                if ((propertyListImpl = (PropertyListImpl)SemanticAnalyzerFactory.this.m_all_options.get(string3)) == null) continue;
                if (!string4.equals("") && SemanticAnalyzerFactory.this.m_taggable_options.get(string3) == null) {
                    errorLog.addEntry(new JSError(TranslatorErrors.option_not_taggable(string3, string4)));
                    ++n;
                    continue;
                }
                if (n != 0) continue;
                String string5 = propertyList.getProperty(string2);
                String string6 = propertyList.getPropertyLocation(string2);
                if (string3.equals("user") && string5 != null) {
                    String string7;
                    SemanticAnalyzerFactory.this.m_connFact.resetConnectData();
                    SemanticAnalyzerFactory.this.m_connFact.setUser(string5);
                    propertyListImpl.addProperty(string4, SemanticAnalyzerFactory.this.m_connFact.getUser(), string6);
                    SemanticAnalyzerFactory.this.m_all_options.put(string3, propertyListImpl);
                    String string8 = SemanticAnalyzerFactory.this.m_connFact.getURL();
                    if (string8 != null) {
                        propertyListImpl = (PropertyListImpl)SemanticAnalyzerFactory.this.m_all_options.get("url");
                        propertyListImpl.addProperty(string4, string8, string6);
                        SemanticAnalyzerFactory.this.m_all_options.put("url", propertyListImpl);
                    }
                    if ((string7 = SemanticAnalyzerFactory.this.m_connFact.getPassword()) == null) continue;
                    propertyListImpl = (PropertyListImpl)SemanticAnalyzerFactory.this.m_all_options.get("password");
                    propertyListImpl.addProperty(string4, string7, string6);
                    SemanticAnalyzerFactory.this.m_all_options.put("password", propertyListImpl);
                    continue;
                }
                propertyListImpl.addProperty(string4, string5, string6);
                SemanticAnalyzerFactory.this.m_all_options.put(string3, propertyListImpl);
            }
            if (n > 0) {
                throw new InvalidOptionException("One or more errors orrured during option processing");
            }
        }

        public String[][] getOptionInfo() {
            Enumeration enumeration = SemanticAnalyzerFactory.this.m_all_options.keys();
            OptionInfoArray optionInfoArray = new OptionInfoArray();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = false;
                PropertyList propertyList = (PropertyList)SemanticAnalyzerFactory.this.m_all_options.get(string);
                String[] stringArray = (String[])SemanticAnalyzerFactory.this.m_all_infos.get(string);
                String[] stringArray2 = new String[]{stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4]};
                if (!propertyList.propertyNames().hasMoreElements()) {
                    optionInfoArray.addInfo(stringArray2);
                } else if (propertyList.getProperty("") != null) {
                    stringArray2[2] = propertyList.getProperty("");
                    stringArray2[4] = propertyList.getPropertyLocation("");
                    optionInfoArray.addInfo(stringArray2);
                    bl = true;
                }
                Enumeration enumeration2 = propertyList.propertyNames();
                while (enumeration2.hasMoreElements()) {
                    String string2 = (String)enumeration2.nextElement();
                    if (!bl) {
                        stringArray2[2] = propertyList.getProperty(string2);
                        stringArray2[4] = propertyList.getPropertyLocation("");
                        optionInfoArray.addInfo(stringArray2);
                        bl = true;
                        continue;
                    }
                    if (string2.equals("")) continue;
                    String[] stringArray3 = new String[]{string + "@" + string2, null, propertyList.getProperty(string2), null, propertyList.getPropertyLocation(string2)};
                    optionInfoArray.addInfo(stringArray3);
                }
            }
            return optionInfoArray.getInfo();
        }
    }
}

