/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.ExecutionContext;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.ref.ProfileGroup;

public abstract class ConnectionContextImpl {
    private ExecutionContext m_execCtx = new ExecutionContext();
    private ProfileGroup.ConnectedGroup m_connProfiles;
    private boolean m_isClosed = false;
    private Connection m_conn;

    protected ConnectionContextImpl(ProfileGroup profileGroup, Connection connection) throws SQLException {
        if (connection == null) {
            RuntimeRefErrors.raise_NULL_CONNECTION();
        }
        this.m_conn = connection;
        this.m_connProfiles = profileGroup.addConnection(connection);
    }

    private ConnectionContextImpl(ProfileGroup profileGroup, Connection connection, boolean bl) throws SQLException {
        this(profileGroup, ConnectionContextImpl.initAutoCommit(connection, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection initAutoCommit(Connection connection, boolean bl) throws SQLException {
        try {
            connection.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            try {
                connection.close();
            }
            catch (SQLException sQLException2) {
                sQLException.setNextException(sQLException2);
            }
            finally {
                throw sQLException;
            }
        }
        return connection;
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, String string2, String string3, boolean bl) throws SQLException {
        this(profileGroup, DriverManager.getConnection(string, string2, string3), bl);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, Properties properties, boolean bl) throws SQLException {
        this(profileGroup, DriverManager.getConnection(string, properties), bl);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, boolean bl) throws SQLException {
        this(profileGroup, DriverManager.getConnection(string), bl);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, ConnectionContext connectionContext) throws SQLException {
        this(profileGroup, connectionContext.getConnection());
    }

    public ConnectedProfile getConnectedProfile(Object object) throws SQLException {
        ConnectedProfile connectedProfile = this.m_connProfiles.getProfile(object);
        return connectedProfile;
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public boolean isClosed() {
        return this.m_isClosed;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) throws SQLException {
        this.m_isClosed = true;
        try {
            this.m_connProfiles.close();
        }
        finally {
            if (bl) {
                this.m_conn.close();
            }
        }
    }

    public ExecutionContext getExecutionContext() {
        return this.m_execCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (!this.m_isClosed) {
                this.close(false);
            }
        }
    }
}

