/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.SQLNullException;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.ref.RTStatementJDBCBase;

public class RTResultSetJDBC
implements RTResultSet {
    protected ResultSet rs;
    private boolean m_isClosed = false;
    private boolean m_isValidRow = false;
    private RTStatementJDBCBase m_parent = null;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public RTResultSetJDBC(ResultSet resultSet) {
        this.rs = resultSet;
    }

    RTResultSetJDBC(ResultSet resultSet, RTStatementJDBCBase rTStatementJDBCBase) {
        this.rs = resultSet;
        this.m_parent = rTStatementJDBCBase;
    }

    public ResultSet getJDBCResultSet() {
        return this.rs;
    }

    public boolean next() throws SQLException {
        this.m_isValidRow = this.rs.next();
        return this.m_isValidRow;
    }

    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    public int findColumn(String string) throws SQLException {
        return this.rs.findColumn(string);
    }

    public String getString(int n) throws SQLException {
        return this.rs.getString(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.rs.getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        return this.rs.getDate(n);
    }

    public Time getTime(int n) throws SQLException {
        return this.rs.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.rs.getTimestamp(n);
    }

    public boolean getBooleanNoNull(int n) throws SQLException {
        boolean bl = this.rs.getBoolean(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return bl;
    }

    public byte getByteNoNull(int n) throws SQLException {
        byte by = this.rs.getByte(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return by;
    }

    public short getShortNoNull(int n) throws SQLException {
        short s = this.rs.getShort(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return s;
    }

    public int getIntNoNull(int n) throws SQLException {
        int n2 = this.rs.getInt(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return n2;
    }

    public long getLongNoNull(int n) throws SQLException {
        long l = this.rs.getLong(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return l;
    }

    public float getFloatNoNull(int n) throws SQLException {
        float f = this.rs.getFloat(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return f;
    }

    public double getDoubleNoNull(int n) throws SQLException {
        double d = this.rs.getDouble(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return d;
    }

    public Boolean getBooleanWrapper(int n) throws SQLException {
        boolean bl = this.rs.getBoolean(n);
        return this.rs.wasNull() ? null : new Boolean(bl);
    }

    public Byte getByteWrapper(int n) throws SQLException {
        byte by = this.rs.getByte(n);
        return this.rs.wasNull() ? null : new Byte(by);
    }

    public Short getShortWrapper(int n) throws SQLException {
        short s = this.rs.getShort(n);
        return this.rs.wasNull() ? null : new Short(s);
    }

    public Integer getIntWrapper(int n) throws SQLException {
        int n2 = this.rs.getInt(n);
        return this.rs.wasNull() ? null : new Integer(n2);
    }

    public Long getLongWrapper(int n) throws SQLException {
        long l = this.rs.getLong(n);
        return this.rs.wasNull() ? null : new Long(l);
    }

    public Float getFloatWrapper(int n) throws SQLException {
        float f = this.rs.getFloat(n);
        return this.rs.wasNull() ? null : new Float(f);
    }

    public Double getDoubleWrapper(int n) throws SQLException {
        double d = this.rs.getDouble(n);
        return this.rs.wasNull() ? null : new Double(d);
    }

    public AsciiStream getAsciiStreamWrapper(int n) throws SQLException {
        InputStream inputStream = this.rs.getAsciiStream(n);
        return inputStream == null || this.rs.wasNull() ? null : new AsciiStream(inputStream);
    }

    public BinaryStream getBinaryStreamWrapper(int n) throws SQLException {
        InputStream inputStream = this.rs.getBinaryStream(n);
        return inputStream == null || this.rs.wasNull() ? null : new BinaryStream(inputStream);
    }

    public UnicodeStream getUnicodeStreamWrapper(int n) throws SQLException {
        InputStream inputStream = this.rs.getBinaryStream(n);
        return inputStream == null || this.rs.wasNull() ? null : new UnicodeStream(inputStream);
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        Object object = this.rs.getObject(n);
        if (object == null) {
            return object;
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            ProfileRefErrors.raise_INCOMPATIBLE_TYPE(clazz, object.getClass());
        }
        return object;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.getObject(n, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = RTResultSetJDBC.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    }

    public int getColumnCount() throws SQLException {
        return this.rs.getMetaData().getColumnCount();
    }

    public boolean isValidRow() throws SQLException {
        return this.m_isValidRow;
    }

    public boolean isClosed() throws SQLException {
        return this.m_isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws SQLException {
        if (this.m_isClosed) return;
        try {
            this.m_isClosed = true;
            this.rs.close();
            Object var2_1 = null;
            if (this.m_parent == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.m_parent == null) throw throwable;
            this.m_parent.notifyClosed(this);
            throw throwable;
        }
        this.m_parent.notifyClosed(this);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (!this.m_isClosed) {
                this.close();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

