/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile;

import java.io.Serializable;

public class SetTransactionDescriptor
implements Serializable {
    private int m_accessMode;
    private int m_isolation;
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    public static final int READ_NONE = 3;
    static final long serialVersionUID = -6317318606668061243L;

    public SetTransactionDescriptor(int n, int n2) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("access mode: " + n);
            }
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("isolation level: " + n2);
            }
        }
        this.m_accessMode = n;
        this.m_isolation = n2;
    }

    public int getAccessMode() {
        return this.m_accessMode;
    }

    public int getIsolationLevel() {
        return this.m_isolation;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ACCESS_MODE=");
        switch (this.getAccessMode()) {
            case 1: {
                stringBuffer.append("READ_ONLY");
                break;
            }
            case 2: {
                stringBuffer.append("READ_WRITE");
                break;
            }
            case 3: {
                stringBuffer.append("NONE");
            }
        }
        stringBuffer.append(",ISOLATION_LEVEL=");
        switch (this.getIsolationLevel()) {
            case 0: {
                stringBuffer.append("NONE");
                break;
            }
            case 2: {
                stringBuffer.append("READ_COMMITTED");
                break;
            }
            case 1: {
                stringBuffer.append("READ_UNCOMMITTED");
                break;
            }
            case 4: {
                stringBuffer.append("REPEATABLE_READ");
                break;
            }
            case 8: {
                stringBuffer.append("SERIALIZABLE");
            }
        }
        return stringBuffer.toString();
    }
}

