/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import java.util.Enumeration;
import java.util.Vector;
import sqlj.framework.BaseJSClass;
import sqlj.framework.JSClass;
import sqlj.framework.JSField;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.javac.ASTConstructorDeclaration;
import sqlj.javac.ASTFormalParameters;
import sqlj.javac.ASTMethodDeclaration;
import sqlj.javac.BaseJavaClass;
import sqlj.javac.JavaParserImpl;
import sqlj.javac.Node;
import sqlj.javac.SimpleNode;
import sqlj.javac.SymTabEntry;
import sqlj.mesg.JavacErrors;
import sqlj.util.ClassDescriptor;
import sqlj.util.ClassNameResolver;
import sqlj.util.NestedClassResolver;
import sqlj.util.Parselet;
import sqlj.util.TypeDescriptor;

public class SimpleTypeNode
extends SimpleNode {
    protected String superClassName = null;
    BaseJSClass baseReflection;
    NestedClassResolver ncr = null;
    private String superName = null;
    private Vector intfNames = new Vector();
    private Vector methods = new Vector();
    private Vector constructors = new Vector();
    private JavaParserImpl javaParser;
    private int numConstructors = 0;
    int iMod = 0;

    public SimpleTypeNode(int n) {
        super(n);
    }

    void setJavaParser(JavaParserImpl javaParserImpl) {
        this.javaParser = javaParserImpl;
    }

    public int setName(String string, ErrorLog errorLog) {
        this.setName(string);
        int n = 0;
        try {
            this.getDescriptor();
        }
        catch (ClassCircularityError classCircularityError) {
            ++n;
            errorLog.addEntry(new JSError(classCircularityError.toString()));
        }
        return n;
    }

    protected NestedClassResolver newClassResolver() {
        return NestedClassResolver.newInstance(this.getName(), this.getJavaScope().getClassResolver());
    }

    private String getFullName() {
        StringBuffer stringBuffer = this.getClassResolver().getClassQualification();
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ClassNameResolver getClassResolver() {
        if (this.ncr == null) {
            this.ncr = this.newClassResolver();
        }
        return this.ncr;
    }

    void setSuperName(String string) {
        this.superName = string;
    }

    public String getSuperName() {
        return this.superName;
    }

    void addInterface(String string) {
        this.intfNames.addElement(string);
    }

    public Vector getInterfaces() {
        return this.intfNames;
    }

    void addMethod(ASTMethodDeclaration aSTMethodDeclaration) {
        this.methods.addElement(aSTMethodDeclaration);
    }

    public Vector getMethods() {
        return this.methods;
    }

    void addConstructor(ASTConstructorDeclaration aSTConstructorDeclaration) {
        this.constructors.addElement(aSTConstructorDeclaration);
        ++this.numConstructors;
    }

    public Vector getConstructors() {
        return this.constructors;
    }

    public Vector getFields() {
        Vector<SymTabEntry> vector = new Vector<SymTabEntry>();
        if (this.symtab != null) {
            Enumeration enumeration = this.symtab.elements();
            while (enumeration.hasMoreElements()) {
                SymTabEntry symTabEntry = (SymTabEntry)enumeration.nextElement();
                if (symTabEntry.isType) continue;
                vector.addElement(symTabEntry);
            }
        }
        return vector;
    }

    public Parselet getEnclosingClass() {
        return this;
    }

    public int insertSymTab(Node node, int n, ErrorLog errorLog) {
        int n2 = 0;
        try {
            TypeDescriptor typeDescriptor = node.getDescriptor();
            if (!(typeDescriptor instanceof ClassDescriptor)) {
                if (typeDescriptor != null) {
                    ++n2;
                    errorLog.addEntry(new JSError(JavacErrors.badlyPlacedSqlj()), node.getBeginLine(), node.getBeginColumn());
                }
                return n2;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)typeDescriptor;
            BaseJSClass baseJSClass = classDescriptor.getBaseReflection();
        }
        catch (ClassCircularityError classCircularityError) {
            ++n2;
            errorLog.addEntry(new JSError(classCircularityError.getMessage()), node.getBeginLine(), node.getBeginColumn());
        }
        return n2;
    }

    void setModifiers(int n) {
        this.iMod = n;
    }

    public TypeDescriptor getDescriptor() {
        if (this.desc != null) {
            return this.desc;
        }
        this.baseReflection = new BaseJavaClass(this, this.getFullName(), this.iMod, this.javaParser);
        this.desc = new ClassDescriptor(this.baseReflection);
        return this.desc;
    }

    public JSClass lookupVarDecl(String string, int n, int n2) throws ClassNotFoundException {
        Object object;
        Node node = this.findName(string, n, n2);
        if (node != null) {
            ClassDescriptor classDescriptor = (ClassDescriptor)node.getDescriptor();
            if (classDescriptor != null) {
                return classDescriptor.getReflection();
            }
            throw new ClassNotFoundException("Class not found: " + string);
        }
        JSClass jSClass = null;
        Node node2 = (Node)this.getEnclosingClass();
        if (node2 != null) {
            object = (ClassDescriptor)node2.getDescriptor();
            JSClass jSClass2 = ((ClassDescriptor)object).getReflection().getSuperclass();
            if (jSClass2 != null && (jSClass = this.resolveVar(jSClass2, string)) != null) {
                return jSClass;
            }
            JSClass[] jSClassArray = ((ClassDescriptor)object).getReflection().getInterfaces();
            int n3 = jSClassArray.length;
            while (n3 > 0) {
                if ((jSClass = this.resolveVar(jSClassArray[--n3], string)) == null) continue;
                return jSClass;
            }
        }
        if ((object = (Node)this.getScope()) != null && (jSClass = object.lookupVarDecl(string, n, n2)) != null) {
            return jSClass;
        }
        return null;
    }

    private JSClass resolveVar(JSClass jSClass, String string) throws ClassNotFoundException {
        JSField[] jSFieldArray = jSClass.getDeclaredFields();
        JSClass jSClass2 = null;
        JSClass jSClass3 = ((ClassDescriptor)this.getDescriptor()).getBaseReflection().getJSClass();
        int n = jSFieldArray.length;
        while (n > 0) {
            if (!string.equals(jSFieldArray[--n].getName()) || !jSClass3.hasAccessTo(jSFieldArray[n])) continue;
            return jSFieldArray[n].getType();
        }
        JSClass jSClass4 = jSClass.getSuperclass();
        if (jSClass4 != null && (jSClass2 = this.resolveVar(jSClass4, string)) != null) {
            return jSClass2;
        }
        JSClass[] jSClassArray = jSClass.getInterfaces();
        n = jSClassArray.length;
        while (n > 0) {
            if ((jSClass2 = this.resolveVar(jSClassArray[--n], string)) == null) continue;
            return jSClass2;
        }
        return null;
    }

    boolean addDefaultConstructor() {
        if (this.numConstructors > 0) {
            return false;
        }
        ASTConstructorDeclaration aSTConstructorDeclaration = new ASTConstructorDeclaration(18);
        aSTConstructorDeclaration.setModifiers(this.iMod & 1);
        ASTFormalParameters aSTFormalParameters = new ASTFormalParameters(16);
        aSTConstructorDeclaration.setFormalParameters(aSTFormalParameters);
        this.addConstructor(aSTConstructorDeclaration);
        return true;
    }
}

