/*
 * Decompiled with CFR 0.152.
 */
package sqlj.framework.ide;

import java.io.IOException;
import java.util.Properties;
import sqlj.framework.ClassResolver;
import sqlj.framework.TranslationException;
import sqlj.framework.ide.IDETranslationUnit;
import sqlj.framework.ide.Options;
import sqlj.framework.ide.TranslationLog;
import sqlj.framework.ide.TranslationOptionsQuery;
import sqlj.framework.ide.TranslationUnit;
import sqlj.framework.options.InvalidOptionException;
import sqlj.framework.options.PropertyListImpl;
import sqlj.mesg.OptionDesc;
import sqlj.translator.ClassResolverImpl;
import sqlj.util.ParseException;
import sqlj.util.io.ErrorLogger;

public class Translator {
    private sqlj.translator.Translator m_translator = null;
    private ErrorLogger m_log = null;
    private TranslationLog m_jslog = null;
    private ClassResolver m_cr = new ClassResolverImpl();
    private static final String COMMAND_LINE = OptionDesc.command_line();

    public Translator(Properties properties, TranslationOptionsQuery translationOptionsQuery, TranslationLog translationLog) throws TranslationException {
        this.m_translator = new sqlj.translator.Translator(translationOptionsQuery);
        this.m_jslog = translationLog;
        PropertyListImpl propertyListImpl = new PropertyListImpl();
        if (properties != null) {
            propertyListImpl.addProperty(properties, COMMAND_LINE);
        }
        this.m_log = new ErrorLogger();
        try {
            this.m_translator.setOptions(propertyListImpl, this.m_log);
        }
        catch (InvalidOptionException invalidOptionException) {
            throw new TranslationException(invalidOptionException.getMessage());
        }
        finally {
            this.m_log.printLog(this.m_jslog);
        }
    }

    public Translator(Options options, TranslationOptionsQuery translationOptionsQuery, TranslationLog translationLog) throws TranslationException {
        this(options.getProps(), translationOptionsQuery, translationLog);
    }

    public static String getVersion() {
        return "/1.0.1.1";
    }

    public void addUnit(TranslationUnit translationUnit) throws TranslationException {
        IDETranslationUnit iDETranslationUnit = null;
        try {
            iDETranslationUnit = new IDETranslationUnit(translationUnit, this.m_cr);
            this.m_translator.addUnit(iDETranslationUnit);
        }
        catch (ParseException parseException) {
            throw new TranslationException(parseException.getMessage());
        }
        catch (IOException iOException) {
            throw new TranslationException(iOException.getMessage());
        }
        finally {
            this.m_log.printLog(this.m_jslog);
        }
    }

    public void translate() throws TranslationException {
        this.translate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(boolean bl) throws TranslationException {
        try {
            this.m_log.printLog(this.m_jslog);
            if (!this.m_translator.translate(bl)) {
                throw new TranslationException("Error occurred in SQLJ translation.");
            }
        }
        finally {
            if (bl) {
                this.m_cr = new ClassResolverImpl();
            }
        }
    }

    public String[][] getOptionInfo() {
        return this.m_translator.getOptionInfo();
    }
}

