/*
 * Decompiled with CFR 0.152.
 */
package sqlj.framework.error;

public class Position {
    private int m_startLine;
    private int m_endLine;
    private int m_startCol;
    private int m_endCol;

    public Position() {
        this(-1, -1, -1, -1);
    }

    public Position(int n, int n2) {
        this(n, n2, n, n2);
    }

    public Position(int n, int n2, int n3, int n4) {
        this.m_startLine = n;
        this.m_startCol = n2;
        this.m_endLine = n3;
        this.m_endCol = n4;
    }

    boolean less(Position position) {
        if (position == null) {
            return false;
        }
        return this.m_startLine < position.startLine() || this.m_startLine == position.startLine() && this.m_endCol < position.endCol();
    }

    public int startLine() {
        return this.m_startLine;
    }

    public int endLine() {
        return this.m_endLine;
    }

    public int startCol() {
        return this.m_startCol;
    }

    public int endCol() {
        return this.m_endCol;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_startLine);
        if (this.m_startCol > 0) {
            stringBuffer.append(".");
            stringBuffer.append(this.m_startCol);
        }
        if (this.m_startLine != this.m_endLine || this.m_startCol != this.m_endCol) {
            stringBuffer.append("-");
            stringBuffer.append(this.m_endLine);
            if (this.m_endCol > 0) {
                stringBuffer.append(".");
                stringBuffer.append(this.m_endCol);
            }
        }
        return stringBuffer.toString();
    }
}

