/*
 * Decompiled with CFR 0.152.
 */
package sqlj.framework;

import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import sqlj.framework.ClassResolver;
import sqlj.framework.JSClass;

public abstract class BaseJSClass {
    private static final int ARRAY_MODS = 1040;
    private static final String OBJECT_NAME = "java.lang.Object";
    private boolean m_isInterface;
    private int m_modifiers;
    private boolean m_isPrimitive;
    private String m_name;
    private JSClass m_componentType = null;
    private ClassResolver m_resolver = null;
    private String m_superclassName = null;
    private JSClass m_fullClass = null;
    private Hashtable m_referringClasses = new Hashtable();
    private ClassNotFoundException m_error = null;

    public BaseJSClass(String string, int n, ClassResolver classResolver) {
        this(string, n, classResolver, null);
    }

    public BaseJSClass(String string, int n, ClassResolver classResolver, String string2) {
        this(string, n, false, classResolver, string2);
    }

    BaseJSClass(String string, int n, boolean bl, ClassResolver classResolver, String string2) {
        this(string, n, bl, string2);
        this.m_componentType = null;
        this.m_resolver = classResolver;
        this.m_resolver.addClass(this);
    }

    BaseJSClass(String string, JSClass jSClass) {
        this(string, BaseJSClass.getArrayMods(jSClass), false, OBJECT_NAME);
        this.m_componentType = jSClass;
        this.m_resolver = null;
    }

    private static int getArrayMods(JSClass jSClass) {
        int n = 1040;
        int n2 = jSClass.getModifiers();
        if (Modifier.isPublic(n2)) {
            n |= 1;
        }
        if (Modifier.isProtected(n2)) {
            n |= 4;
        }
        if (Modifier.isPrivate(n2)) {
            n |= 2;
        }
        return n;
    }

    private BaseJSClass(String string, int n, boolean bl, String string2) {
        this.m_modifiers = n;
        this.m_isInterface = Modifier.isInterface(n);
        this.m_isPrimitive = bl;
        this.m_name = string;
        if (this.m_isPrimitive || this.m_isInterface) {
            if (string2 != null) {
                throw new IllegalArgumentException();
            }
        } else {
            if (string2 == null && !string.equals(OBJECT_NAME)) {
                this.m_superclassName = OBJECT_NAME;
            }
            this.m_superclassName = string2;
        }
    }

    public final boolean isInterface() {
        return this.m_isInterface;
    }

    public final boolean isArray() {
        return this.m_componentType != null;
    }

    public final boolean isPrimitive() {
        return this.m_isPrimitive;
    }

    public final String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    public final JSClass getComponentType() {
        return this.m_componentType;
    }

    public final int getModifiers() {
        return this.m_modifiers;
    }

    public final String getSuperclassName() {
        return this.m_superclassName;
    }

    final void setJSClass(JSClass jSClass) {
        if (this.m_fullClass == null) {
            this.m_fullClass = jSClass;
        } else if (this.m_fullClass != jSClass) {
            throw new IllegalArgumentException("JSClass for this BaseJSClass already exists");
        }
    }

    private void invalidateJSClass() {
        if (this.m_fullClass != null) {
            this.m_fullClass = null;
            Enumeration enumeration = this.m_referringClasses.elements();
            while (enumeration.hasMoreElements()) {
                ((BaseJSClass)enumeration.nextElement()).invalidateJSClass();
            }
            this.m_referringClasses.clear();
        }
    }

    public final JSClass getJSClass() throws ClassNotFoundException {
        if (this.m_error != null) {
            throw this.m_error;
        }
        if (this.m_fullClass == null) {
            try {
                this.createJSClass();
                if (this.m_fullClass == null) {
                    throw new ClassNotFoundException(this.getName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.invalidateJSClass();
                this.m_error = classNotFoundException;
                throw classNotFoundException;
            }
        }
        return this.m_fullClass;
    }

    JSClass resolveClass(String string) throws ClassNotFoundException {
        return this.resolveClass(this.m_resolver.getClass(string));
    }

    JSClass resolveClass(BaseJSClass baseJSClass) throws ClassNotFoundException {
        return baseJSClass.getJSClass(this);
    }

    private JSClass getJSClass(BaseJSClass baseJSClass) throws ClassNotFoundException {
        JSClass jSClass = this.getJSClass();
        this.m_referringClasses.put(baseJSClass.getName(), baseJSClass);
        return jSClass;
    }

    ClassResolver getClassResolver() {
        return this.m_resolver;
    }

    protected abstract JSClass createJSClass() throws ClassNotFoundException;
}

