/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import java.util.Hashtable;
import sqlj.framework.BaseJSClass;
import sqlj.framework.ClassResolver;
import sqlj.framework.JSClass;

public class JavaToSQLMap {
    private static final Hashtable m_javaToSQLTable = JavaToSQLMap.newJavaToSQLTable();
    private MapClassResolver m_classResolver = new MapClassResolver();

    private static Hashtable newJavaToSQLTable() {
        Hashtable<JSClass, Integer> hashtable = new Hashtable<JSClass, Integer>();
        hashtable.put(JSClass.String_TYPE, new Integer(12));
        hashtable.put(JSClass.BigDecimal_TYPE, new Integer(2));
        hashtable.put(JSClass.boolean_TYPE, new Integer(-7));
        hashtable.put(JSClass.byte_TYPE, new Integer(-6));
        hashtable.put(JSClass.short_TYPE, new Integer(5));
        hashtable.put(JSClass.int_TYPE, new Integer(4));
        hashtable.put(JSClass.long_TYPE, new Integer(-5));
        hashtable.put(JSClass.float_TYPE, new Integer(7));
        hashtable.put(JSClass.double_TYPE, new Integer(8));
        hashtable.put(JSClass.bytearray_TYPE, new Integer(-3));
        hashtable.put(JSClass.Date_TYPE, new Integer(91));
        hashtable.put(JSClass.Time_TYPE, new Integer(92));
        hashtable.put(JSClass.Timestamp_TYPE, new Integer(93));
        hashtable.put(JSClass.Boolean_TYPE, new Integer(-7));
        hashtable.put(JSClass.Byte_TYPE, new Integer(-6));
        hashtable.put(JSClass.Short_TYPE, new Integer(5));
        hashtable.put(JSClass.Integer_TYPE, new Integer(4));
        hashtable.put(JSClass.Long_TYPE, new Integer(-5));
        hashtable.put(JSClass.Float_TYPE, new Integer(7));
        hashtable.put(JSClass.Double_TYPE, new Integer(8));
        return hashtable;
    }

    public int mapType(JSClass jSClass) {
        Integer n = (Integer)m_javaToSQLTable.get(jSClass);
        int n2 = 1111;
        if (n != null) {
            n2 = n;
        }
        return n2;
    }

    public int mapType(Class clazz) {
        return this.mapType(JSClass.reflect(clazz, this.m_classResolver));
    }

    public JSClass toJSClass(Class clazz) {
        return JSClass.reflect(clazz, this.m_classResolver);
    }

    private static class MapClassResolver
    implements ClassResolver {
        private Hashtable m_classes = new Hashtable();

        private MapClassResolver() {
        }

        public BaseJSClass getClass(String string) throws ClassNotFoundException {
            BaseJSClass baseJSClass = this.getQualifiedClass(string);
            if (baseJSClass == null) {
                throw new ClassNotFoundException(string);
            }
            return baseJSClass;
        }

        public BaseJSClass getQualifiedClass(String string) {
            BaseJSClass baseJSClass = (BaseJSClass)this.m_classes.get(string);
            if (baseJSClass == null) {
                baseJSClass = ClassResolver.SYSTEM_CLASSES.getQualifiedClass(string);
            }
            return baseJSClass;
        }

        public void addClass(BaseJSClass baseJSClass) {
            if (this.isLoadedClass(baseJSClass.getName())) {
                throw new ClassCircularityError(baseJSClass.getName() + " has already been defined");
            }
            this.m_classes.put(baseJSClass.getName(), baseJSClass);
        }

        public boolean isLoadedClass(String string) {
            return this.m_classes.containsKey(string) || ClassResolver.SYSTEM_CLASSES.isLoadedClass(string);
        }
    }
}

