/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import sqlj.codegen.BaseCodegen;
import sqlj.codegen.ExecStmt;
import sqlj.codegen.FetchIntoStmt;
import sqlj.codegen.IntoGroup;
import sqlj.codegen.IteratorMetaData;
import sqlj.codegen.JSClassType;
import sqlj.codegen.JavaToSQLMap;
import sqlj.codegen.ProfileDecl;
import sqlj.codegen.ProfileKeysDecl;
import sqlj.codegen.QueryExecStmt;
import sqlj.codegen.SelectIntoStmt;
import sqlj.codegen.TypedExpression;
import sqlj.codegen.UnitInfo;
import sqlj.codegen.UpdateExecStmt;
import sqlj.codegen.Util;
import sqlj.codegen.engine.CodegenException;
import sqlj.codegen.engine.Expression;
import sqlj.codegen.engine.ObjectExpression;
import sqlj.codegen.engine.Statement;
import sqlj.codegen.engine.StatementGroup;
import sqlj.codegen.engine.Streamable;
import sqlj.framework.JSClass;
import sqlj.framework.error.JSError;
import sqlj.mesg.CodegenErrors;
import sqlj.syntax.BindExpr;
import sqlj.syntax.DirectBindExpr;
import sqlj.syntax.ExecElem;
import sqlj.syntax.IntoBindExpr;
import sqlj.syntax.ReturnBindExpr;
import sqlj.syntax.SQLUnit;
import sqlj.util.ClassDescriptor;
import sqlj.util.DefaultParselet;
import sqlj.util.ExpressionDescriptor;
import sqlj.util.ExpressionMetaData;
import sqlj.util.OutputContext;
import sqlj.util.Parselet;
import sqlj.util.TypeDescriptor;
import sqlj.util.UnitDescriptor;

class ExecCodegen
extends BaseCodegen {
    private JSClassType.Factory m_typeFactory;
    private ExecElem m_execElem;
    private static final String TEMP_RESULT_SET = Util.newVarName("rtRs");
    private static final JavaToSQLMap JAVA_TO_SQL = new JavaToSQLMap();
    private static final JSClass[] EMPTY_ARGS = new JSClass[0];
    private Statement m_execGenerator = null;

    public ExecCodegen(ExecElem execElem, JSClassType.Factory factory) {
        super(execElem);
        this.m_execElem = execElem;
        this.m_typeFactory = factory;
    }

    private void createGenerator() throws CodegenException {
        if (this.m_execGenerator != null) {
            return;
        }
        try {
            this.m_execGenerator = this.m_execElem.getSQL().getOperationType() == 1022 ? this.createFetchStmt() : this.createExecStmt();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace(System.out);
            this.m_execElem.getErrorLog().addEntry(new JSError("unable to generate exec codegen (ClassNotFound)"));
            throw new CodegenException();
        }
    }

    private Statement createFetchStmt() throws CodegenException, ClassNotFoundException {
        Enumeration enumeration = this.m_execElem.getSQL().getBindExprs();
        if (!enumeration.hasMoreElements()) {
            throw new CodegenException("no cursor to fetch from");
        }
        DirectBindExpr directBindExpr = (DirectBindExpr)enumeration.nextElement();
        if (!enumeration.hasMoreElements()) {
            throw new CodegenException("no list to fetch into");
        }
        IntoBindExpr intoBindExpr = (IntoBindExpr)enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            throw new CodegenException("extra fetch bind vars found");
        }
        TypedExpression typedExpression = new TypedExpression(directBindExpr.getParselet(), this.m_typeFactory);
        if (!FetchIntoStmt.isFetchExpression(typedExpression)) {
            throw new CodegenException("cannot fetch from non-cursor");
        }
        FetchIntoStmt fetchIntoStmt = new FetchIntoStmt(typedExpression);
        IntoGroup intoGroup = fetchIntoStmt.getIntoGroup();
        this.populateIntoGroup(intoGroup, intoBindExpr);
        return fetchIntoStmt;
    }

    private Statement createExecStmt() throws ClassNotFoundException, CodegenException {
        Parselet parselet = this.m_execElem.getScope().getDefiningUnit();
        UnitDescriptor unitDescriptor = (UnitDescriptor)parselet.getDescriptor();
        TypedExpression typedExpression = this.getConnCtxExpr(this.m_execElem);
        TypedExpression typedExpression2 = this.getExecCtxExpr(this.m_execElem);
        ProfileKeysDecl profileKeysDecl = this.getProfileKeys(parselet, unitDescriptor, this.m_execElem);
        ProfileDecl profileDecl = this.getProfile(profileKeysDecl, typedExpression.getType(), unitDescriptor);
        return this.getExecStmt(profileKeysDecl, profileDecl, typedExpression, typedExpression2, this.m_execElem);
    }

    private Parselet getContextExpr(ExecElem execElem, JSClass jSClass) throws ClassNotFoundException {
        Enumeration enumeration = execElem.getContextExprList();
        while (enumeration.hasMoreElements()) {
            Parselet parselet = (Parselet)enumeration.nextElement();
            JSClass jSClass2 = ((ExpressionDescriptor)parselet.getDescriptor()).getReflection();
            if (!jSClass.isAssignableFrom(jSClass2)) continue;
            return parselet;
        }
        return null;
    }

    private TypedExpression getConnCtxExpr(ExecElem execElem) throws ClassNotFoundException {
        Parselet parselet = this.getContextExpr(execElem, JSClass.ConnectionContext_TYPE);
        if (parselet == null) {
            JSClassType jSClassType = this.m_typeFactory.getType(UnitInfo.getInfoFor(execElem).getDefaultContext());
            parselet = new ContextParselet(jSClassType);
        }
        return new TypedExpression(parselet, this.m_typeFactory);
    }

    private TypedExpression getExecCtxExpr(ExecElem execElem) throws ClassNotFoundException {
        Parselet parselet = this.getContextExpr(execElem, JSClass.ExecutionContext_TYPE);
        if (parselet == null) {
            return null;
        }
        return new TypedExpression(parselet, this.m_typeFactory);
    }

    private ProfileKeysDecl getProfileKeys(Parselet parselet, UnitDescriptor unitDescriptor, ExecElem execElem) throws CodegenException {
        Streamable streamable;
        Object object;
        Enumeration enumeration = unitDescriptor.getClassDecls();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof CodegenParselet) || !((streamable = ((CodegenParselet)object).getStreamableObject()) instanceof ProfileKeysDecl)) continue;
            return (ProfileKeysDecl)streamable;
        }
        object = unitDescriptor.getFileName();
        if (object == null) {
            object = unitDescriptor.getUnitName();
        } else if (!this.isValidJavaIdentifier((String)object)) {
            throw new CodegenException(CodegenErrors.bad_filename(object));
        }
        if (object == null) {
            throw new Error("bad unit descriptor - null file and unit name");
        }
        streamable = new ProfileKeysDecl(Util.getClassPrefix(parselet).toString(), (String)object, parselet, execElem.getErrorLog().getFileName());
        unitDescriptor.addClassDecl(new CodegenParselet(streamable));
        return streamable;
    }

    private boolean isValidJavaIdentifier(String string) {
        int n = string.length();
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private ProfileDecl getProfile(ProfileKeysDecl profileKeysDecl, JSClassType jSClassType, UnitDescriptor unitDescriptor) {
        boolean bl = !profileKeysDecl.hasProfile(jSClassType);
        ProfileDecl profileDecl = profileKeysDecl.getProfileDecl(jSClassType);
        if (bl) {
            unitDescriptor.addClassDecl(new ProfileParselet(profileDecl));
        }
        return profileDecl;
    }

    private Statement getExecStmt(ProfileKeysDecl profileKeysDecl, ProfileDecl profileDecl, TypedExpression typedExpression, TypedExpression typedExpression2, ExecElem execElem) throws CodegenException, ClassNotFoundException {
        ExecStmt execStmt;
        int n;
        SQLUnit sQLUnit = execElem.getSQL();
        String string = sQLUnit.getSQL();
        int n2 = this.mapRole(sQLUnit.getOperationType());
        int n3 = this.calcStatementType(n2, sQLUnit);
        ReturnBindExpr returnBindExpr = sQLUnit.getReturnBindExpr();
        int n4 = 128;
        Parselet parselet = execElem.getResultExpr();
        TypedExpression typedExpression3 = parselet == null ? null : new TypedExpression(parselet, this.m_typeFactory);
        JSClassType jSClassType = null;
        if (n2 == 8) {
            n = 16;
            if (typedExpression3 != null) {
                throw new CodegenException("cursor lval found select into");
            }
            typedExpression3 = new TypedExpression(JSClassType.RTResultSet_TYPE, new ObjectExpression(TEMP_RESULT_SET), TEMP_RESULT_SET);
            n4 = 64;
        } else if (n2 == 4) {
            n = 24;
        } else if (returnBindExpr == null || returnBindExpr == ReturnBindExpr.COLUMN_RETURN) {
            n = 8;
        } else {
            n = 16;
            if (typedExpression3 == null) {
                throw new CodegenException("null cursor lval found in exec");
            }
            JSClass jSClass = typedExpression3.getJSClass();
            jSClassType = typedExpression3.getType();
            if (JSClass.PositionedIterator_TYPE.isAssignableFrom(jSClass)) {
                n4 = 64;
            } else if (JSClass.NamedIterator_TYPE.isAssignableFrom(jSClass)) {
                n4 = 32;
            } else {
                throw new CodegenException("incompatible lval found in exec");
            }
        }
        int n5 = execElem.getErrorLog().getDefaultRegion().startLine();
        ProfileDecl.EntryInit entryInit = profileDecl.newEntry(string, n3, n, n2, n4, this.getEntryDescriptor(n2, sQLUnit), n5, jSClassType);
        Expression expression = profileKeysDecl.getProfileKey(typedExpression.getType());
        Expression expression2 = entryInit.getEntryKey();
        switch (n) {
            case 16: {
                execStmt = new QueryExecStmt(n3, typedExpression, typedExpression2, expression, expression2, typedExpression3, n2 != 8);
                break;
            }
            case 8: 
            case 24: {
                execStmt = new UpdateExecStmt(n3, (Expression)typedExpression, (Expression)typedExpression2, expression, expression2, n);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown exec type");
            }
        }
        StatementGroup statementGroup = execStmt;
        IntoGroup intoGroup = null;
        if (n2 == 8) {
            SelectIntoStmt selectIntoStmt = new SelectIntoStmt(execStmt, TEMP_RESULT_SET);
            intoGroup = selectIntoStmt.getIntoGroup();
            statementGroup = selectIntoStmt;
            this.addResultTypes(entryInit, sQLUnit.getIntoBindExpr());
        } else if (n == 16) {
            this.addResultTypes(entryInit, typedExpression3, execElem);
        }
        this.addParamTypes(entryInit, execStmt, sQLUnit, typedExpression3, intoGroup);
        return statementGroup;
    }

    private Object getEntryDescriptor(int n, SQLUnit sQLUnit) {
        return sQLUnit.getDescriptor();
    }

    private int mapRole(int n) {
        return n;
    }

    private int calcStatementType(int n, SQLUnit sQLUnit) {
        Enumeration enumeration = sQLUnit.getBindExprs();
        while (enumeration.hasMoreElements()) {
            int n2;
            BindExpr bindExpr = (BindExpr)enumeration.nextElement();
            if (!(bindExpr instanceof DirectBindExpr ? (n2 = ((DirectBindExpr)bindExpr).getModality()) == 4 || n2 == 2 : bindExpr == ReturnBindExpr.COLUMN_RETURN)) continue;
            return 4;
        }
        return 2;
    }

    private void addParamTypes(ProfileDecl.EntryInit entryInit, ExecStmt execStmt, SQLUnit sQLUnit, TypedExpression typedExpression, IntoGroup intoGroup) throws CodegenException, ClassNotFoundException {
        Enumeration enumeration = sQLUnit.getBindExprs();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            BindExpr bindExpr = (BindExpr)enumeration.nextElement();
            if (bindExpr instanceof DirectBindExpr) {
                DirectBindExpr directBindExpr = (DirectBindExpr)bindExpr;
                TypedExpression typedExpression2 = new TypedExpression(directBindExpr.getParselet(), this.m_typeFactory);
                int n2 = directBindExpr.getModality();
                this.addParamType(entryInit, execStmt, typedExpression2, n2, sQLUnit.getMarkerPosition(n));
                ++n;
                continue;
            }
            if (bindExpr instanceof IntoBindExpr) {
                if (intoGroup == null) {
                    throw new CodegenException("unexpected into found");
                }
                this.populateIntoGroup(intoGroup, (IntoBindExpr)bindExpr);
                intoGroup = null;
                continue;
            }
            if (!(bindExpr instanceof ReturnBindExpr) || bindExpr != ReturnBindExpr.COLUMN_RETURN) continue;
            if (typedExpression == null) {
                throw new CodegenException("no lval found in exec");
            }
            this.addParamType(entryInit, execStmt, typedExpression, 5, sQLUnit.getMarkerPosition(n));
            ++n;
        }
    }

    private void addResultTypes(ProfileDecl.EntryInit entryInit, IntoBindExpr intoBindExpr) throws ClassNotFoundException {
        Enumeration enumeration = intoBindExpr.getParselets();
        while (enumeration.hasMoreElements()) {
            TypedExpression typedExpression = new TypedExpression((Parselet)enumeration.nextElement(), this.m_typeFactory);
            JSClassType jSClassType = typedExpression.getType();
            entryInit.addResult(jSClassType, JAVA_TO_SQL.mapType(jSClassType.toClass()), typedExpression.getName());
        }
    }

    private void addResultTypes(ProfileDecl.EntryInit entryInit, TypedExpression typedExpression, ExecElem execElem) throws CodegenException {
        IteratorMetaData iteratorMetaData;
        JSClass jSClass = typedExpression.getJSClass();
        try {
            iteratorMetaData = new IteratorMetaData(jSClass, this.getCaller(execElem, jSClass));
        }
        catch (IteratorMetaData.Exception exception) {
            throw new CodegenException(exception.getMessage());
        }
        if (iteratorMetaData.isByPosition() || iteratorMetaData.isByName()) {
            int n = iteratorMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                JSClass jSClass2 = iteratorMetaData.getColumnType(i);
                entryInit.addResult(this.m_typeFactory.getType(jSClass2), JAVA_TO_SQL.mapType(jSClass2), iteratorMetaData.getColumnName(i));
            }
        }
    }

    private JSClass getCaller(ExecElem execElem, JSClass jSClass) {
        try {
            Parselet parselet = execElem.getScope().getEnclosingClass();
            return ((ClassDescriptor)parselet.getDescriptor()).getReflection();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return jSClass;
        }
    }

    private void populateIntoGroup(IntoGroup intoGroup, IntoBindExpr intoBindExpr) throws ClassNotFoundException {
        Enumeration enumeration = intoBindExpr.getParselets();
        while (enumeration.hasMoreElements()) {
            intoGroup.addIntoVar(new TypedExpression((Parselet)enumeration.nextElement(), this.m_typeFactory));
        }
    }

    private void addParamType(ProfileDecl.EntryInit entryInit, ExecStmt execStmt, TypedExpression typedExpression, int n, int n2) {
        execStmt.addParam(typedExpression, n);
        if (n == 5) {
            n = 4;
        }
        JSClassType jSClassType = typedExpression.getType();
        entryInit.addParam(jSClassType, JAVA_TO_SQL.mapType(jSClassType.toClass()), typedExpression.getName(), n, n2);
    }

    public void generate(PrintWriter printWriter) throws IOException, CodegenException {
        this.createGenerator();
        this.m_execGenerator.stream(printWriter);
    }

    private static class ContextParselet
    extends CodegenParselet {
        TypeDescriptor m_desc;

        public ContextParselet(JSClassType jSClassType) {
            super(new ObjectExpression(jSClassType.name() + "." + "getDefaultContext" + "()"));
            this.m_desc = new ExpressionDescriptor(ExpressionMetaData.DEFAULT, jSClassType.toClass().getBaseJSClass());
        }

        public TypeDescriptor getDescriptor() {
            return this.m_desc;
        }
    }

    private static class ProfileParselet
    extends DefaultParselet {
        private ProfileDecl m_profile;

        public ProfileParselet(ProfileDecl profileDecl) {
            this.m_profile = profileDecl;
        }

        public boolean generate(OutputContext outputContext) throws IOException {
            UnitInfo unitInfo = UnitInfo.getInfoFor(this);
            if (unitInfo.wasError()) {
                return false;
            }
            OutputStream outputStream = outputContext.createOutputStream(this.m_profile.getName() + ".ser");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this.m_profile.getProfile());
            objectOutputStream.flush();
            outputStream.close();
            return true;
        }
    }

    private static class CodegenParselet
    extends DefaultParselet {
        private Streamable m_streamableObj;

        public CodegenParselet(Streamable streamable) {
            this.m_streamableObj = streamable;
        }

        public Streamable getStreamableObject() {
            return this.m_streamableObj;
        }

        public boolean generate(OutputContext outputContext) throws IOException {
            return BaseCodegen.generate(outputContext.getWriter(), this.m_streamableObj);
        }
    }
}

