/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.ErrorMap;
import amazon.emr.metrics.TimeInterval;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueCountMap {
    long minTime = 0L;
    long maxTime = 0L;
    TreeMap<Long, Integer> values = new TreeMap();
    ErrorMap errorMap = new ErrorMap();
    int totalValueCount = 0;
    long sum = 0L;

    public void add(MetricProtos.EmrMetricRawValue v) {
        if (this.minTime == 0L || this.minTime > v.getTime()) {
            this.minTime = v.getTime();
        }
        this.maxTime = Math.max(this.maxTime, v.getTime());
        if (v.hasValue()) {
            this.addValue(v.getValue(), 1);
            ++this.totalValueCount;
            this.sum += v.getValue();
        }
        if (v.hasError()) {
            this.errorMap.add(v.getError(), 1);
        }
    }

    public void add(MetricProtos.EmrMetricAggregatedValue v) {
        if (this.minTime == 0L || this.minTime > v.getStart()) {
            this.minTime = v.getStart();
        }
        this.maxTime = Math.max(this.maxTime, v.getStop());
        if (v.getCount() > 0) {
            this.addValue((long)v.getAverage(), v.getCount());
            this.totalValueCount += v.getCount();
            this.sum += v.getSum();
        }
        if (v.getNumError() > 0) {
            this.errorMap.add(v.getErrorsList());
        }
    }

    public void addRawValues(Vector<MetricProtos.EmrMetricRawValue> values) {
        if (values == null) {
            return;
        }
        for (MetricProtos.EmrMetricRawValue v : values) {
            this.add(v);
        }
    }

    public void addAggValues(Vector<MetricProtos.EmrMetricAggregatedValue> values) {
        if (values == null) {
            return;
        }
        for (MetricProtos.EmrMetricAggregatedValue v : values) {
            this.add(v);
        }
    }

    public void addRawValues(List<MetricProtos.EmrMetricRawValue> values) {
        if (values == null) {
            return;
        }
        for (MetricProtos.EmrMetricRawValue v : values) {
            this.add(v);
        }
    }

    public void addAggValues(List<MetricProtos.EmrMetricAggregatedValue> values) {
        if (values == null) {
            return;
        }
        for (MetricProtos.EmrMetricAggregatedValue v : values) {
            this.add(v);
        }
    }

    public void addRecords(Collection<MetricProtos.EmrMetricRecord> records) {
        if (records == null) {
            return;
        }
        for (MetricProtos.EmrMetricRecord record : records) {
            this.addRawValues(record.getValuesList());
            this.addAggValues(record.getValuesExList());
        }
    }

    boolean isEmpty() {
        return this.totalValueCount == 0 && this.errorMap.getTotalCount() == 0;
    }

    public MetricProtos.EmrMetricAggregatedValue aggregate() {
        return this.aggregate(this.minTime, this.maxTime);
    }

    public MetricProtos.EmrMetricAggregatedValue aggregate(TimeInterval interval) {
        return this.aggregate(interval.start, interval.stop);
    }

    public MetricProtos.EmrMetricAggregatedValue aggregate(long startTime, long stopTime) {
        MetricProtos.EmrMetricAggregatedValue.Builder vb = MetricProtos.EmrMetricAggregatedValue.newBuilder();
        vb.setCount(this.totalValueCount);
        vb.setStart(startTime);
        vb.setStop(stopTime);
        if (this.totalValueCount > 0) {
            vb.setSum(this.sum);
            vb.setAverage(this.sum / (long)this.totalValueCount);
            int tp90Index = (int)Math.ceil((double)this.totalValueCount * 0.9) - 1;
            int tp99Index = (int)Math.ceil((double)this.totalValueCount * 0.99) - 1;
            boolean tp90set = false;
            for (Map.Entry<Long, Integer> e : this.values.entrySet()) {
                tp99Index -= e.getValue().intValue();
                if ((tp90Index -= e.getValue().intValue()) < 0 && !tp90set) {
                    vb.setTp90(e.getKey().longValue());
                    tp90set = true;
                }
                if (tp99Index >= 0) continue;
                vb.setTp99(e.getKey().longValue());
                break;
            }
        }
        if (this.errorMap != null) {
            this.errorMap.export(vb);
            vb.setNumError(this.errorMap.getTotalCount());
        }
        return vb.build();
    }

    private void addValue(long value, int count) {
        Integer V = this.values.get(value);
        this.values.put(value, V == null ? count : V + count);
    }
}

