/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeInterval {
    static final Logger logger = LoggerFactory.getLogger(TimeInterval.class);
    public final long start;
    public final long stop;
    final long duration;

    public static long getIntervalStart(long t, int Tsec) {
        return t - t % (long)(Tsec * 1000);
    }

    public TimeInterval(long t, long T) {
        this(t, T, false);
    }

    public TimeInterval(long t, long T, boolean absolute) {
        if (absolute) {
            this.start = t;
            this.stop = t + T;
            this.duration = T;
        } else {
            this.start = t - t % T;
            this.stop = this.start + T;
            this.duration = T;
        }
    }

    public TimeInterval(String s) {
        int i = s.indexOf(45);
        int j = s.indexOf(44);
        if (i >= 0 && j >= 0) {
            throw new RuntimeException("Invalid interval " + s);
        }
        i = i >= 0 ? i : j;
        long ts = i == 0 ? 0L : Long.parseLong(s.substring(0, i));
        long tt = i < s.length() - 1 ? Long.parseLong(s.substring(i + 1)) : System.currentTimeMillis();
        this.start = this.getEquivMillis(ts);
        this.stop = this.getEquivMillis(tt);
        if (this.stop <= this.start) {
            throw new RuntimeException("Invalid interval " + s);
        }
        this.duration = (int)Math.min(86400000L, this.stop - this.start);
    }

    public long getEquivMillis(long t) {
        return t < 9999999999L ? t * 1000L : t;
    }

    public boolean contains(long time) {
        return time >= this.start && time < this.stop;
    }

    public boolean overlapWith(MetricProtos.FileChunk chunk) {
        return this.contains(chunk.getMinTime()) || this.contains(chunk.getMaxTime());
    }

    TimeInterval getNextInterval() {
        return new TimeInterval(this.stop, this.duration);
    }

    public String toString() {
        return String.format("[%d, %d)", this.start / 1000L, this.stop / 1000L);
    }

    public String toStringNoParenthese() {
        return String.format("%d-%d", this.start / 1000L, this.stop / 1000L);
    }
}

